/*
 * Decompiled with CFR 0.152.
 */
package com.carneiro.mcredsim;

import com.carneiro.mcredsim.Blocks;
import com.carneiro.mcredsim.Colors;
import com.carneiro.mcredsim.Expander;
import com.carneiro.mcredsim.Field;
import com.carneiro.mcredsim.LevelLoader;
import com.carneiro.mcredsim.Palette;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Node;

public class Viewport
implements MouseWheelListener {
    public static final String title = "Redstone Simulator v2.1";
    static final Object[][] blockNames = new Object[][]{{"Rock", 1}, {"Grass/Dirt", 2}, {"Dirt", 3}, {"Cobblestone", 4}, {"Wood", 5}, {"Adminium", 7}, {"Sand", 12}, {"Gravel", 13}, {"Gold ore", 14}, {"Iron ore", 15}, {"Coal ore", 16}, {"Tree trunk", 17}, {"Sponge", 19}, {"Cloth", 35}, {"Gold", 41}, {"Iron", 42}, {"Double stair", 43}, {"Brick", 45}, {"Bookshelf", 47}, {"Mossy cobblestone", 48}, {"Obsidian", 49}, {"Diamond ore", 56}, {"Diamond", 57}, {"Redstone ore", 73}, {"Snow", 80}, {"Clay", 82}};
    static final int iX = 30;
    static final int iY = 20;
    static final int iZ = 7;
    static final int MS_PER_TICK = 62;
    static final int GIF_DELAY = 200;
    static final boolean IS_MAC = System.getProperty("os.name").toLowerCase().indexOf("mac") != -1;
    static final boolean doubleDoors = false;
    static boolean waterMode = false;
    int block = 2;
    JFrame frame;
    JDialog adjF;
    JDialog optF;
    JPanel view;
    JPanel pView;
    StatusBar stats;
    Field field;
    Palette[] palArr = Palette.pal3;
    int pal;
    int scale = 3;
    int pScale = 5;
    int lyr = 0;
    int gd = 0;
    int x;
    int y;
    int z;
    int cloneMode = 0;
    int lastX;
    int lastY;
    int lastPX;
    int lastPY;
    int[] clone = null;
    JLabel lLyr;
    JLabel lSz;
    JLabel lLoc;
    JLabel lRed;
    JLabel lTorch;
    JLabel lTot;
    JLabel tooltip;
    JSeparator sLoc;
    JButton tick;
    JButton play;
    JCheckBox c1Lyr;
    JCheckBox c3Lyr;
    JCheckBox cBridge;
    JCheckBox cWater;
    Icon playII;
    Icon pauseII;
    JMenuItem tickMI;
    File save = null;
    File folder = new File("~");
    boolean playing = false;
    boolean isCtrlDown = false;
    boolean modified = false;
    Timer pTimer;

    private Icon getImage(String loc, int s, String desc) {
        URL u = this.getClass().getResource("/images/" + loc + s + ".gif");
        if (u == null) {
            return new MissingIcon(s, s);
        }
        return new ImageIcon(u, desc);
    }

    private URL getSound(String loc) {
        return this.getClass().getResource("/sound/" + loc);
    }

    private void addCtrl(JPanel p, JComponent c) {
        c.setAlignmentX(0.5f);
        p.add(c);
    }

    private JButton addBtn(JPanel p, String img, String t, ActionListener a) {
        JButton b = new JButton(t);
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setPreferredSize(new Dimension(40, 20));
        b.setMaximumSize(new Dimension(40, 20));
        b.addActionListener(a);
        this.addCtrl(p, b);
        return b;
    }

    private void addAdjCol(JPanel p, String s, String b1, String b2, boolean e1, boolean e2, int e3) {
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 3));
        JLabel l = new JLabel(s);
        l.setAlignmentX(0.5f);
        Dimension d = l.getPreferredSize();
        l.setMaximumSize(new Dimension(d.width + 1, d.height));
        p2.add(l);
        p2.add(Box.createRigidArea(new Dimension(5, 5)));
        this.addBtn(p2, String.valueOf(e1 ? "Grow" : "Shrink") + s, b1, new Expander(this, e1, e2, e3));
        p2.add(Box.createRigidArea(new Dimension(5, 5)));
        this.addBtn(p2, String.valueOf(e1 ? "Shrink" : "Grow") + s, b2, new Expander(this, !e1, e2, e3));
        p.add(p2);
        p.add(Box.createRigidArea(new Dimension(5, 5)));
    }

    public void setSize(int _x, int _y, int _z) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
        this.lSz.setText(String.valueOf(this.x) + "x" + this.y + "x" + this.z);
        Dimension d = new Dimension((this.x * 9 + 1) * this.scale, (this.y * 9 + 1) * this.scale);
        this.view.setPreferredSize(d);
        this.view.revalidate();
    }

    public void addScale(int ds) {
        this.scale += ds;
        if (this.scale < 1) {
            this.scale = 1;
        }
        Dimension d = new Dimension((this.x * 9 + 1) * this.scale, (this.y * 9 + 1) * this.scale);
        this.view.setPreferredSize(d);
        this.view.revalidate();
        this.view.repaint();
    }

    public void setLyr(int l) {
        if (l < 0) {
            l = 0;
        }
        if (l >= this.z) {
            l = this.z - 1;
        }
        this.lyr = l;
        this.lLyr.setText("Layer " + (this.lyr + 1));
        if (this.lyr < this.gd) {
            this.lLyr.setForeground(Colors.dirt);
        } else {
            this.lLyr.setForeground(Color.BLUE.darker());
        }
        if (this.clone != null) {
            if (this.clone.length == 6) {
                this.setClone(this.clone[3], this.clone[4], this.lyr);
            } else if (this.clone.length == 9) {
                this.setClone(this.clone[6], this.clone[7], this.lyr);
            }
        }
    }

    public void recountRed() {
        this.field.torches = 0;
        this.field.wires = 0;
        int i = 0;
        while (i < this.z) {
            int j = 0;
            while (j < this.y) {
                int k = 0;
                while (k < this.x) {
                    if (this.field.g(k, j, i) == Blocks.wire) {
                        ++this.field.wires;
                    } else if (this.field.g(k, j, i) == Blocks.torch) {
                        ++this.field.torches;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.updateRed();
    }

    public void updateRed() {
        this.lRed.setText(String.valueOf(this.field.wires));
        this.lTorch.setText(String.valueOf(this.field.torches));
        this.lTot.setText(String.valueOf(this.field.wires + this.field.torches));
        this.stats.revalidate();
    }

    private int[] findDoor(int x, int y, int z) {
        int z2 = z - 1;
        while (z2 < z + 2) {
            if (this.field.g(x - 1, y, z2) == Blocks.doorA) {
                return new int[]{x - 1, y, z2, 1};
            }
            if (this.field.g(x + 1, y, z2) == Blocks.doorA) {
                return new int[]{x + 1, y, z2, 2};
            }
            if (this.field.g(x, y - 1, z2) == Blocks.doorA) {
                return new int[]{x, y - 1, z2, 3};
            }
            if (this.field.g(x, y + 1, z2) == Blocks.doorA) {
                return new int[]{x, y + 1, z2, 4};
            }
            ++z2;
        }
        return null;
    }

    private void place(int x, int y, int z, Palette pal) {
        int[] d;
        if (this.field.match(x, y, z, pal) && pal != Palette.water) {
            return;
        }
        if (pal == Palette.door && z == this.z - 1) {
            return;
        }
        if (!(pal.a.wall != 3 || this.field.g(x, y + 1, z).block() || this.field.g(x, y - 1, z).block() || this.field.g(x + 1, y, z).block() || this.field.g(x - 1, y, z).block())) {
            return;
        }
        this.modify();
        this.field.s(x, y, z, pal.a);
        if (Field.layers > 1) {
            if (pal.b != null) {
                this.field.s(x, y, z + 1, pal.b);
            }
            if (Field.layers > 2 && pal.c != null) {
                this.field.s(x, y, z + 2, pal.c);
            }
        }
        if (pal.a == Blocks.wire || pal.a == Blocks.press) {
            this.field.s(x, y, z - 1, Blocks.block);
        }
        if (pal == Palette.water) {
            this.field.sp(x, y, z, 16);
        } else if (pal == Palette.door && (d = this.findDoor(x, y, z)) != null && this.field.w(d[0], d[1], d[2]) == d[3]) {
            this.field.s(x, y, z, 4 - this.field.w(d[0], d[1], d[2]));
            this.field.s(x, y, z + 1, 1);
        } else {
            int p = z + 1;
            if (this.field.g((int)x, (int)y, (int)z).wall != 0) {
                --p;
            }
            if (p == z || this.field.g((int)x, (int)y, (int)(z + 1)).wall != 0) {
                int w = 0;
                if (this.field.g(x, y, p) == Blocks.torch) {
                    this.field.sp(x, y, p, 16);
                }
                do {
                    ++w;
                } while (!this.field.s(x, y, p, w %= 5));
                if (this.field.w(x, y, p) == 0 || this.field.g((int)x, (int)y, (int)z).wall == 2) {
                    this.field.s(x, y, p - 1, Blocks.block);
                }
                if (pal == Palette.door) {
                    this.field.s(x, y, p + 1, 1);
                }
            }
        }
        this.field.update();
        this.view.repaint();
    }

    public Viewport(int _x, int _y, int _z) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
        this.field = new Field(this, this.x, this.y, this.z);
        this.init();
    }

    public Viewport(byte[][][] d, byte[][][] e) {
        this.x = d[0][0].length;
        this.y = d[0].length;
        this.z = d.length;
        this.field = new Field(this, d, e);
        this.init();
        this.recountRed();
        this.field.update();
    }

    private void init() {
        this.init_setupFrame();
        this.init_buildAdjust();
        this.init_buildOptions();
        this.frame.setContentPane(this.init_buildMenuBar(this.init_buildStatusBar(this.init_buildToolbar(this.init_buildPView(this.init_buildView())))));
        this.init_doKeyBindings();
        this.setSize(this.x, this.y, this.z);
        this.frame.pack();
        this.frame.setLocationByPlatform(true);
        this.view.requestFocusInWindow();
        this.frame.setVisible(true);
    }

    private void init_setupFrame() {
        int i = 0;
        while (i < this.palArr.length) {
            if (this.palArr[i] == Palette.wire) {
                this.pal = i;
            }
            ++i;
        }
        this.frame = new JFrame(title);
        URL u = this.getClass().getResource("/images/Logo16.png");
        if (u != null) {
            Image im = new ImageIcon(u, "").getImage();
            ArrayList<Image> al = new ArrayList<Image>();
            al.add(im);
            int i2 = 16;
            while (i2 < 256) {
                al.add(im.getScaledInstance(i2, i2, 8));
                i2 *= 2;
            }
            this.frame.setIconImages(al);
        }
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                new ButtonAction(14).actionPerformed(null);
            }
        });
    }

    private void init_buildAdjust() {
        this.adjF = new JDialog((Frame)this.frame, "Adjust Size");
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 2));
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
        this.addAdjCol(p, "Top", "\u2191", "\u2193", true, false, 1);
        this.addAdjCol(p, "Bottom", "\u2191", "\u2193", false, true, 1);
        this.addAdjCol(p, "Left", "\u2192", "\u2190", false, false, 2);
        this.addAdjCol(p, "Right", "\u2192", "\u2190", true, true, 2);
        this.addAdjCol(p, "Front", "\u2299", "\u2295", true, true, 0);
        this.addAdjCol(p, "Back", "\u2299", "\u2295", false, false, 0);
        this.adjF.setContentPane(p);
        this.adjF.setDefaultCloseOperation(1);
        this.adjF.pack();
        this.adjF.setLocationByPlatform(true);
    }

    private void init_buildOptions() {
        this.optF = new JDialog((Frame)this.frame, "Options");
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JCheckBox c = new JCheckBox("Cyclic (in X and Z only) ");
        p.add(c);
        c.addItemListener(new OptionAction(0));
        c = new JCheckBox("\"Natural\" wire connections ");
        p.add(c);
        c.addItemListener(new OptionAction(1));
        c = new JCheckBox("Ground switches power blocks below ");
        p.add(c);
        c.setSelected(true);
        c.addItemListener(new OptionAction(2));
        this.c1Lyr = new JCheckBox("Show only one layer ");
        p.add(this.c1Lyr);
        this.c1Lyr.addItemListener(new OptionAction(3));
        this.c3Lyr = new JCheckBox("Show three layers ");
        p.add(this.c3Lyr);
        this.c3Lyr.setSelected(true);
        this.c3Lyr.addItemListener(new OptionAction(4));
        this.cBridge = new JCheckBox("Show bridges ");
        p.add(this.cBridge);
        this.cBridge.setSelected(true);
        this.cBridge.addItemListener(new OptionAction(5));
        String[] bS = new String[blockNames.length];
        int i = 0;
        while (i < bS.length) {
            bS[i] = (String)blockNames[i][0];
            ++i;
        }
        JComboBox<String> cb = new JComboBox<String>(bS);
        p.add(cb);
        cb.setAlignmentX(0.0f);
        cb.setSelectedIndex(1);
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewport.this.block = (Integer)blockNames[((JComboBox)e.getSource()).getSelectedIndex()][1];
            }
        });
        this.cWater = new JCheckBox("Water circuit mode ");
        this.cWater.addItemListener(new OptionAction(6));
        this.optF.setContentPane(p);
        this.optF.setDefaultCloseOperation(1);
        this.optF.setResizable(false);
        this.optF.pack();
        this.optF.setLocationByPlatform(true);
    }

    private JScrollPane init_buildView() {
        this.view = new JPanel(null){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Viewport.this.paintView(g);
            }
        };
        this.view.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Viewport.this.viewMouseMoved(e, false);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Viewport.this.viewMouseMoved(e, true);
            }
        });
        this.view.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Viewport.this.viewMousePressed(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Viewport.this.lastPY = -1;
                Viewport.this.lastPX = -1;
                Viewport.this.updateTooltip();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.frame.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                Viewport.this.frameResized();
            }
        });
        this.tooltip = new JLabel("");
        this.view.add(this.tooltip);
        this.tooltip.setVisible(false);
        this.tooltip.setOpaque(true);
        this.tooltip.setBackground(Colors.tooltip);
        JScrollPane sp = new JScrollPane(this.view);
        this.view.setFocusable(true);
        this.view.setFocusTraversalKeysEnabled(false);
        sp.setAlignmentX(0.5f);
        sp.setWheelScrollingEnabled(false);
        this.frame.addMouseWheelListener(this);
        sp.addMouseWheelListener(this);
        return sp;
    }

    private void init_doKeyBindings() {
        InputMap im = this.view.getInputMap(0);
        im.put(KeyStroke.getKeyStroke("UP"), "up");
        im.put(KeyStroke.getKeyStroke("DOWN"), "down");
        im.put(KeyStroke.getKeyStroke("PERIOD"), "tick");
        im.put(KeyStroke.getKeyStroke("ctrl PERIOD"), "tick");
        im.put(KeyStroke.getKeyStroke("ENTER"), "pause");
        im.put(KeyStroke.getKeyStroke("ctrl ENTER"), "pause");
        im.put(KeyStroke.getKeyStroke("ESCAPE"), "esc");
        im.put(KeyStroke.getKeyStroke("CONTROL"), "cDown");
        im.put(KeyStroke.getKeyStroke("released CONTROL"), "cUp");
        this.view.getActionMap().put("up", new ButtonAction(7));
        this.view.getActionMap().put("down", new ButtonAction(8));
        this.view.getActionMap().put("tick", new ButtonAction(4));
        this.view.getActionMap().put("pause", new ButtonAction(6));
        this.view.getActionMap().put("esc", new ButtonAction(11));
        this.view.getActionMap().put("cDown", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewport.this.isCtrlDown = true;
                Viewport.this.updateTooltip();
                System.out.println("down");
            }
        });
        this.view.getActionMap().put("cUp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Viewport.this.isCtrlDown = false;
                Viewport.this.updateTooltip();
            }
        });
    }

    private JPanel init_buildPView(JScrollPane sp) {
        this.pView = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Viewport.this.paintPView(g);
            }
        };
        Dimension d = new Dimension((this.palArr.length * 9 + 1) * this.pScale, 10 * this.pScale);
        this.pView.setPreferredSize(d);
        this.pView.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Viewport.this.pViewMousePressed(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        JPanel main = new JPanel();
        GroupLayout layout = new GroupLayout(main);
        main.setLayout(layout);
        this.pView.setAlignmentX(0.5f);
        JLabel lC = new JLabel();
        JLabel lD = new JLabel();
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(sp, 0, -2, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(lC, 0, 0, Short.MAX_VALUE).addComponent(this.pView, -2, -2, -2).addComponent(lD, 0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(sp, 0, -2, Short.MAX_VALUE).addGroup(layout.createParallelGroup().addComponent(lC, 0, 0, 0).addComponent(this.pView, -2, -2, -2).addComponent(lD, 0, 0, 0)));
        return main;
    }

    private JPanel init_buildToolbar(JPanel main) {
        JPanel p = new JPanel(new BorderLayout());
        JToolBar tb = new JToolBar("Tools");
        tb.setRollover(true);
        this.addButton(tb, "New", "New", 0);
        this.addButton(tb, "Open", "Open", 3);
        this.addButton(tb, "Save", "Save", 2);
        tb.addSeparator();
        this.addButton(tb, "Export as GIF", "Camera", 16);
        this.addButton(tb, "Clone", "Copy", 1);
        tb.addSeparator();
        this.tick = this.addButton(tb, "Tick", "StepForward", 4);
        this.play = this.addButton(tb, "Play", "Play", 6);
        this.playII = this.play.getIcon();
        this.pauseII = this.getImage("Pause", 24, "Pause");
        tb.addSeparator();
        this.addButton(tb, "Layer Up", "Up", 7);
        this.addButton(tb, "Layer Down", "Down", 8);
        tb.addSeparator();
        this.addButton(tb, "Zoom In", "ZoomIn", 12);
        this.addButton(tb, "Zoom Out", "ZoomOut", 13);
        tb.addSeparator();
        this.addButton(tb, "Adjust Size", "AlignCenter", 9);
        this.addButton(tb, "Options", "Preferences", 10);
        p.add((Component)main, "Center");
        p.add((Component)tb, "First");
        return p;
    }

    private JButton addButton(JToolBar tb, String name, String file, int action) {
        JButton b = new JButton();
        b.setToolTipText(name);
        b.addActionListener(new ButtonAction(action));
        b.setIcon(this.getImage(file, 24, name));
        b.setFocusable(false);
        b.setFocusTraversalKeysEnabled(false);
        tb.add(b);
        return b;
    }

    private JPanel init_buildStatusBar(JPanel p) {
        JPanel p2 = new JPanel(new BorderLayout());
        p2.add((Component)p, "Center");
        this.stats = new StatusBar();
        this.lLyr = new JLabel("Layer 1");
        this.stats.add(this.lLyr);
        this.lLyr.setForeground(Color.BLUE.darker());
        this.stats.addSeparator();
        this.lSz = new JLabel(String.valueOf(this.x) + "x" + this.y + "x" + this.z);
        this.stats.add(this.lSz);
        this.stats.addSeparator();
        this.lLoc = new JLabel();
        this.stats.add(this.lLoc);
        this.sLoc = this.stats.addSeparator();
        this.lLoc.setVisible(false);
        this.sLoc.setVisible(false);
        this.stats.addGlue();
        this.stats.addSeparator();
        this.lRed = new JLabel("0");
        this.stats.add(this.lRed);
        this.stats.add(new JLabel(this.getImage("Redstone", 16, "Redstone")));
        this.stats.addSeparator();
        this.lTorch = new JLabel("0");
        this.stats.add(this.lTorch);
        this.stats.add(new JLabel(this.getImage("Torch", 16, "Torches")));
        this.stats.addSeparator();
        this.lTot = new JLabel("0");
        this.stats.add(this.lTot);
        this.stats.add(new JLabel(this.getImage("Ore", 16, "Total")));
        p2.add((Component)this.stats, "Last");
        this.lRed.setForeground(Colors.wireOff.darker());
        this.lTorch.setForeground(Colors.wireOff.darker());
        this.lTot.setForeground(Colors.wireOff.darker());
        return p2;
    }

    private JPanel init_buildMenuBar(JPanel p2) {
        JMenuBar menubar = new JMenuBar();
        int CTRL = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        int SHIFT = 64;
        int ALT = 512;
        JMenu menu = new JMenu(" File ");
        menu.setMnemonic(70);
        menubar.add(menu);
        this.addMenuItem(menu, "New", 78, "New", CTRL, 78, new ButtonAction(0));
        this.addMenuItem(menu, "Open", 79, "Open", CTRL, 79, new ButtonAction(3));
        menu.addSeparator();
        this.addMenuItem(menu, "Save", 83, "Save", CTRL, 83, new ButtonAction(2));
        this.addMenuItem(menu, "Save As...", 65, "SaveAs", CTRL | SHIFT, 83, new ButtonAction(15));
        menu.addSeparator();
        this.addMenuItem(menu, "Export as GIF", 71, "Camera", CTRL, 71, new ButtonAction(16));
        menu.addSeparator();
        if (IS_MAC) {
            this.addMenuItem(menu, "Quit", 81, "Stop", CTRL, 81, new ButtonAction(14));
        } else {
            this.addMenuItem(menu, "Exit", 88, "Stop", ALT, 115, new ButtonAction(14));
        }
        menu = new JMenu(" Edit ");
        menu.setMnemonic(69);
        menubar.add(menu);
        this.addMenuItem(menu, "Clone", 67, "Copy", CTRL, 67, new ButtonAction(1));
        menu.addSeparator();
        this.tickMI = this.addMenuItem(menu, "Tick", 84, "StepForward", 0, 46, new ButtonAction(4));
        this.addMenuItem(menu, "Play/Pause", 80, "Play", 0, 10, new ButtonAction(6));
        menu = new JMenu(" View ");
        menu.setMnemonic(86);
        menubar.add(menu);
        this.addMenuItem(menu, "Layer Up", 85, "Up", 0, 87, new ButtonAction(7));
        this.addMenuItem(menu, "Layer Down", 68, "Down", 0, 83, new ButtonAction(8));
        menu.addSeparator();
        this.addMenuItem(menu, "Zoom In", 73, "ZoomIn", 0, 61, new ButtonAction(12));
        this.addMenuItem(menu, "Zoom Out", 79, "ZoomOut", 0, 45, new ButtonAction(13));
        menu.addSeparator();
        this.addMenuItem(menu, "Options...", 80, "Preferences", CTRL, 44, new ButtonAction(10));
        menu.addSeparator();
        JMenu menu2 = new JMenu("Look & Feel");
        menu2.setMnemonic(76);
        menu.add(menu2);
        ButtonGroup group = new ButtonGroup();
        String mn = "";
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = lookAndFeelInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo l = lookAndFeelInfoArray[n2];
            JRadioButtonMenuItem i = new JRadioButtonMenuItem(l.getName(), l.getClassName().equals(UIManager.getCrossPlatformLookAndFeelClassName()));
            int j = 0;
            while (j < l.getName().length()) {
                char c = l.getName().toLowerCase().charAt(j);
                if (!mn.contains(String.valueOf(c))) {
                    mn = String.valueOf(mn) + c;
                    i.setMnemonic(c);
                    break;
                }
                ++j;
            }
            i.addActionListener(new LAFActionListener(l.getClassName()));
            group.add(menu2.add(i));
            ++n2;
        }
        menu = new JMenu(" Adjust Size ");
        menu.setMnemonic(65);
        menubar.add(menu);
        this.addMenuItem(menu, "Adjust Size...", 65, "AlignCenter", CTRL, 65, new ButtonAction(9));
        menu.addSeparator();
        menu2 = new JMenu("Shrink");
        menu2.setMnemonic(83);
        menu.add(menu2);
        this.addMenuItem2(menu2, "Top face down", 84, "ShrinkTop", CTRL, 104, new Expander(this, false, false, 1));
        this.addMenuItem2(menu2, "Bottom face up", 66, "ShrinkBottom", CTRL, 98, new Expander(this, false, true, 1));
        this.addMenuItem2(menu2, "Left face right", 76, "ShrinkLeft", CTRL, 100, new Expander(this, false, false, 2));
        this.addMenuItem2(menu2, "Right face left", 82, "ShrinkRight", CTRL, 102, new Expander(this, false, true, 2));
        this.addMenuItem2(menu2, "Front (sky) face down", 83, "ShrinkFront", CTRL, 105, new Expander(this, false, true, 0));
        this.addMenuItem2(menu2, "Back (ground) face up", 71, "ShrinkBack", CTRL, 99, new Expander(this, false, false, 0));
        menu2 = new JMenu("Grow");
        menu2.setMnemonic(71);
        menu.add(menu2);
        this.addMenuItem2(menu2, "Top face up", 84, "GrowTop", 0, 104, new Expander(this, true, false, 1));
        this.addMenuItem2(menu2, "Bottom face down", 66, "GrowBottom", 0, 98, new Expander(this, true, true, 1));
        this.addMenuItem2(menu2, "Left face left", 76, "GrowLeft", 0, 100, new Expander(this, true, false, 2));
        this.addMenuItem2(menu2, "Right face right", 82, "GrowRight", 0, 102, new Expander(this, true, true, 2));
        this.addMenuItem2(menu2, "Front (sky) face up", 83, "GrowFront", 0, 105, new Expander(this, true, true, 0));
        this.addMenuItem2(menu2, "Back (ground) face down", 71, "GrowBack", 0, 99, new Expander(this, true, false, 0));
        p2.add((Component)menubar, "First");
        return p2;
    }

    private JMenuItem addMenuItem2(JMenu m, String name, int mnem, String file, int mod, int key, Action al) {
        JMenuItem i = this.addMenuItem(m, name, mnem, file, mod, key, al);
        this.view.getInputMap(0).put(KeyStroke.getKeyStroke(key, mod | 0x40), file);
        this.view.getActionMap().put(file, al);
        return i;
    }

    private JMenuItem addMenuItem(JMenu m, String name, int mnem, String file, int mod, int key, ActionListener al) {
        JMenuItem i = new JMenuItem(name, mnem);
        if (file != null) {
            i.setIcon(this.getImage(file, 16, name));
        }
        if (key != 0) {
            i.setAccelerator(KeyStroke.getKeyStroke(key, mod));
        }
        i.addActionListener(al);
        return m.add(i);
    }

    private void paintView(Graphics g) {
        g.setColor(Colors.air);
        Rectangle r = g.getClipBounds();
        g.fillRect(r.x, r.y, r.width, r.height);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.scale(this.scale, this.scale);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Colors.grid);
        g2.fillRect(0, 0, this.x * 9 + 1, this.y * 9 + 1);
        if (this.clone != null) {
            int x1 = this.clone[0];
            int y1 = this.clone[1];
            int z1 = this.clone[2];
            int x2 = this.clone[3];
            int y2 = this.clone[4];
            int z2 = this.clone[5];
            if (x2 < x1) {
                x1 = x2;
                x2 = this.clone[0];
            }
            if (y2 < y1) {
                y1 = y2;
                y2 = this.clone[1];
            }
            if (z2 < z1) {
                z1 = z2;
                z2 = this.clone[2];
            }
            if (this.lyr >= z1 && this.lyr <= z2) {
                g2.setColor(Colors.copyFrom);
                g2.fillRect(x1 * 9, y1 * 9, (x2 - x1) * 9 + 10, 1);
                g2.fillRect(x1 * 9, y1 * 9, 1, (y2 - y1) * 9 + 10);
                g2.fillRect(x1 * 9, y2 * 9 + 9, (x2 - x1) * 9 + 10, 1);
                g2.fillRect(x2 * 9 + 9, y1 * 9, 1, (y2 - y1) * 9 + 10);
            }
            if (this.clone.length > 6) {
                int x3 = this.clone[6];
                int y3 = this.clone[7];
                int z3 = this.clone[8];
                int x4 = x3 + x2 - x1;
                int y4 = y3 + y2 - y1;
                int z4 = z3 + z2 - z1;
                if (this.lyr >= z3 && this.lyr <= z4) {
                    g2.setColor(Colors.copyTo);
                    g2.fillRect(x3 * 9, y3 * 9, (x4 - x3) * 9 + 10, 1);
                    g2.fillRect(x3 * 9, y3 * 9, 1, (y4 - y3) * 9 + 10);
                    g2.fillRect(x3 * 9, y4 * 9 + 9, (x4 - x3) * 9 + 10, 1);
                    g2.fillRect(x4 * 9 + 9, y3 * 9, 1, (y4 - y3) * 9 + 10);
                }
            }
        }
        int i = r.x / this.scale / 9;
        while ((i * 9 + 1) * this.scale < r.x + r.width && i < this.x) {
            int j = r.y / this.scale / 9;
            while ((j * 9 + 1) * this.scale < r.y + r.height && j < this.y) {
                this.field.draw(i, j, this.lyr, g2, new Rectangle(i * 9 + 1, j * 9 + 1, 8, 8), new Blocks[0]);
                ++j;
            }
            ++i;
        }
    }

    private void viewMouseMoved(MouseEvent e, boolean dragged) {
        Point pt = e.getPoint();
        this.lastPX = pt.x;
        this.lastPY = pt.y;
        this.isCtrlDown = e.isControlDown();
        this.updateTooltip();
        if (this.lastX < 0 || this.lastY < 0) {
            return;
        }
        if (dragged) {
            int bi;
            if (this.cloneMode != 0) {
                return;
            }
            if ((e.getModifiersEx() & 0x400) != 0 && !this.field.g(this.lastX, this.lastY, this.lyr).ctrl() && !this.field.g(this.lastX, this.lastY, this.lyr + 1).ctrl()) {
                bi = 0;
            } else if ((e.getModifiersEx() & 0x1000) != 0) {
                bi = this.pal;
            } else {
                return;
            }
            this.place(this.lastX, this.lastY, this.lyr, this.palArr[bi]);
        } else {
            if (!this.isCtrlDown && this.playing) {
                int p = this.lyr + 1;
                if (this.field.g(this.lastX, this.lastY, p) != Blocks.press) {
                    --p;
                }
                if (p != this.lyr || this.field.g(this.lastX, this.lastY, p) == Blocks.press) {
                    this.field.sp(this.lastX, this.lastY, p, 10);
                    this.field.update();
                    this.view.repaint();
                }
            }
            this.setClone(this.lastX, this.lastY, this.lyr);
        }
    }

    private void viewMousePressed(MouseEvent e) {
        Point pt = e.getPoint();
        this.lastPX = pt.x;
        this.lastPY = pt.y;
        this.isCtrlDown = e.isControlDown();
        this.updateTooltip();
        if (this.lastX < 0 || this.lastY < 0) {
            return;
        }
        if (this.cloneMode != 0) {
            ++this.cloneMode;
            if (this.cloneMode == 3) {
                int l = this.clone[2];
                if (this.clone[5] < this.clone[2]) {
                    l = this.clone[5];
                }
                int[] nArray = new int[9];
                nArray[6] = this.lastX;
                nArray[7] = this.lastY;
                nArray[8] = l;
                int[] x = nArray;
                System.arraycopy(this.clone, 0, x, 0, 6);
                this.clone = x;
                this.setLyr(l);
            } else if (this.cloneMode == 4) {
                this.cloneMode = 0;
                int i = 0;
                while (i < 3) {
                    if (this.clone[i + 3] >= this.clone[i]) {
                        int n = i + 3;
                        this.clone[n] = this.clone[n] + (1 - this.clone[i]);
                    } else {
                        int t = this.clone[i + 3];
                        this.clone[i + 3] = this.clone[i] - t + 1;
                        this.clone[i] = t;
                    }
                    ++i;
                }
                this.field.clone(this.clone);
                this.recountRed();
                this.clone = null;
            }
            this.view.repaint();
            return;
        }
        int bi = this.pal;
        switch (e.getButton()) {
            case 1: {
                bi = 0;
                int p = this.lyr + 1;
                if (this.field.g(this.lastX, this.lastY, this.lyr).ctrl()) {
                    --p;
                }
                if (p == this.lyr || this.field.g(this.lastX, this.lastY, this.lyr + 1).ctrl()) {
                    if (this.field.g(this.lastX, this.lastY, p) == Blocks.lever) {
                        this.field.sp(this.lastX, this.lastY, p, this.field.p(this.lastX, this.lastY, p) ? 0 : 16);
                    } else if (this.field.g(this.lastX, this.lastY, p) == Blocks.button && !this.field.p(this.lastX, this.lastY, p)) {
                        this.field.sp(this.lastX, this.lastY, p, 10);
                    } else if (this.field.g(this.lastX, this.lastY, p) == Blocks.press && !this.playing) {
                        this.field.sp(this.lastX, this.lastY, p, this.field.p(this.lastX, this.lastY, p) ? 0 : 10);
                    }
                    this.field.update();
                    this.view.repaint();
                    break;
                }
            }
            case 3: {
                this.place(this.lastX, this.lastY, this.lyr, this.palArr[bi]);
                break;
            }
            case 2: {
                int w;
                int p = this.lyr + 1;
                if (this.field.g((int)this.lastX, (int)this.lastY, (int)this.lyr).wall != 0) {
                    --p;
                }
                if (p != this.lyr && this.field.g((int)this.lastX, (int)this.lastY, (int)(this.lyr + 1)).wall == 0) break;
                if (this.field.g(this.lastX, this.lastY, p) == Blocks.doorB) {
                    --p;
                }
                int ow = w = this.field.w(this.lastX, this.lastY, p);
                do {
                    ++w;
                } while (!this.field.s(this.lastX, this.lastY, p, w %= 5));
                if (ow == w) break;
                this.field.update();
                this.view.repaint();
            }
        }
    }

    private void paintPView(Graphics g2) {
        g2.setColor(Colors.grid);
        Rectangle r = g2.getClipBounds();
        g2.fillRect(r.x, r.y, r.width, r.height);
        Graphics2D g = (Graphics2D)g2.create();
        g.scale(this.pScale, this.pScale);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Colors.hilite);
        g.fillRect(this.pal * 9, 0, 10, 10);
        int i = 0;
        while (i < this.palArr.length) {
            r = new Rectangle(i * 9 + 1, 1, 8, 8);
            Palette p = this.palArr[i];
            this.field.draw(0, 0, 0, g, r, p.a, p.b == null ? Blocks.air : p.b, p.c == null ? Blocks.air : p.c);
            ++i;
        }
    }

    private void pViewMousePressed(MouseEvent e) {
        Point p = e.getPoint();
        int pX = p.x / this.pScale;
        if (pX % 9 == 0) {
            return;
        }
        if ((pX /= 9) >= this.palArr.length) {
            return;
        }
        this.pal = pX;
        this.pView.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.isControlDown()) {
            this.addScale(-e.getWheelRotation());
        } else {
            int l = this.palArr.length;
            this.pal = ((this.pal + e.getWheelRotation()) % l + l) % l;
            this.pView.repaint();
        }
    }

    private void frameResized() {
        this.pScale = this.frame.getContentPane().getWidth() / (this.palArr.length * 9 + 1);
        if (this.pScale > 5) {
            this.pScale = 5;
        }
        if (this.pScale < 2) {
            this.pScale = 2;
        }
        Dimension d = new Dimension((this.palArr.length * 9 + 1) * this.pScale, 10 * this.pScale);
        this.pView.setPreferredSize(d);
        this.pView.setMaximumSize(d);
        this.pView.revalidate();
    }

    private void playToggle() {
        if (this.playing) {
            this.pTimer.stop();
            this.pTimer = null;
            this.play.setIcon(this.playII);
            this.tick.setEnabled(true);
            this.tickMI.setEnabled(true);
        } else {
            this.pTimer = new Timer(62, new ButtonAction(5));
            this.pTimer.start();
            this.play.setIcon(this.pauseII);
            this.tick.setEnabled(false);
            this.tickMI.setEnabled(false);
        }
        this.playing = !this.playing;
    }

    public void setClone(int pX, int pY, int pZ) {
        if (this.cloneMode == 1) {
            this.clone[0] = this.clone[3] = pX;
            this.clone[1] = this.clone[4] = pY;
            this.clone[2] = this.clone[5] = pZ;
        } else if (this.cloneMode == 2) {
            this.clone[3] = pX;
            this.clone[4] = pY;
            this.clone[5] = pZ;
        } else if (this.cloneMode == 3) {
            this.clone[6] = pX;
            this.clone[7] = pY;
            this.clone[8] = pZ;
        }
        if (this.cloneMode != 0) {
            this.view.repaint();
        }
    }

    private void setPalette(Palette[] p) {
        Palette sel = this.palArr[this.pal];
        int wireInd = 0;
        this.pal = -1;
        this.palArr = p;
        int i = 0;
        while (i < p.length) {
            if (p[i] == sel) {
                this.pal = i;
            } else if (p[i] == Palette.wire) {
                wireInd = i;
            }
            ++i;
        }
        if (this.pal == -1) {
            this.pal = wireInd;
        }
        Dimension d = new Dimension((this.palArr.length * 9 + 1) * this.pScale, 10 * this.pScale);
        this.pView.setPreferredSize(d);
        this.pView.setMaximumSize(d);
        this.pView.revalidate();
    }

    public void updateTooltip() {
        int pX = this.lastPX / this.scale;
        int pY = this.lastPY / this.scale;
        if (this.lastPX < 0 || this.lastPY < 0 || pX < 0 || pY < 0 || pX > this.x * 9 || pY > this.y * 9) {
            this.lastY = -1;
            this.lastX = -1;
            this.tooltip.setVisible(false);
            this.lLoc.setVisible(false);
            this.sLoc.setVisible(false);
            return;
        }
        if (pX % 9 == 0 || pY % 9 == 0) {
            return;
        }
        this.lastX = pX /= 9;
        this.lastY = pY /= 9;
        this.lLoc.setText("X=" + this.lastX + ", Y=" + this.lyr + ", Z=" + this.lastY);
        this.lLoc.setVisible(true);
        this.sLoc.setVisible(true);
        if (!this.isCtrlDown) {
            this.tooltip.setVisible(false);
            return;
        }
        this.tooltip.setLocation((this.lastX * 9 + 10) * this.scale, (this.lastY * 9 + 1) * this.scale);
        this.tooltip.setVisible(true);
        String s = "<html>" + this.lastX + "," + this.lyr + "," + this.lastY + "<p>";
        if (Field.layers > 2) {
            s = String.valueOf(s) + this.field.g((int)this.lastX, (int)this.lastY, (int)(this.lyr + 2)).name + " on ";
        }
        if (Field.layers > 1) {
            s = String.valueOf(s) + this.field.g((int)this.lastX, (int)this.lastY, (int)(this.lyr + 1)).name + " on ";
        }
        s = String.valueOf(s) + this.field.g((int)this.lastX, (int)this.lastY, (int)this.lyr).name;
        String[] dir = new String[]{"ground", "west", "east", "south", "north"};
        int i = 0;
        while (i < Field.layers) {
            int p = this.lyr + i;
            switch (this.field.g(this.lastX, this.lastY, p)) {
                case button: {
                    s = String.valueOf(s) + "<p>button: attached to " + dir[this.field.w(this.lastX, this.lastY, p)] + " face" + "<p>button: " + (this.field.p(this.lastX, this.lastY, p) ? String.valueOf(this.field.gp(this.lastX, this.lastY, p)) + " ticks of power left" : "unpowered");
                    break;
                }
                case doorB: {
                    if (i != 0) break;
                    --p;
                }
                case doorA: {
                    s = String.valueOf(s) + "<p>door: hinge at " + (new String[]{"no", "NW", "SE", "NE", "SW"})[this.field.w(this.lastX, this.lastY, p)] + " corner" + "<p>door: " + (this.field.p(this.lastX, this.lastY, p) ? "" : "un") + "powered";
                    break;
                }
                case torch: {
                    s = String.valueOf(s) + "<p>torch: attached to " + dir[this.field.w(this.lastX, this.lastY, p)] + " face" + "<p>torch: " + (this.field.p(this.lastX, this.lastY, p) ? "" : "un") + "powered";
                    break;
                }
                case lever: {
                    s = String.valueOf(s) + "<p>switch: attached to " + dir[this.field.w(this.lastX, this.lastY, p)] + " face" + "<p>switch: " + (this.field.p(this.lastX, this.lastY, p) ? "" : "un") + "powered";
                    break;
                }
                case press: {
                    s = String.valueOf(s) + "<p>pressure plate: " + (this.field.p(this.lastX, this.lastY, p) ? (this.field.gp(this.lastX, this.lastY, p) == 10 ? "powered" : String.valueOf(this.field.gp(this.lastX, this.lastY, p)) + " ticks of power left") : "unpowered");
                    break;
                }
                case wire: {
                    s = String.valueOf(s) + "<p>wire: " + (this.field.p(this.lastX, this.lastY, p) ? "will carry power for " + this.field.gp(this.lastX, this.lastY, p) + " blocks" : "unpowered");
                    break;
                }
                case water: {
                    s = String.valueOf(s) + "<p>water: " + ((this.field.gp(this.lastX, this.lastY, p) & 0xF) == 0 ? "source" : "level " + (8 - (this.field.gp(this.lastX, this.lastY, p) & 7))) + ((this.field.gp(this.lastX, this.lastY, p) & 8) == 0 ? "" : ", falling") + ((this.field.gp(this.lastX, this.lastY, p) & 0x10) == 0 ? " (static)" : " (dynamic)");
                }
            }
            ++i;
        }
        this.tooltip.setText(s);
        this.tooltip.setSize(this.tooltip.getPreferredSize());
    }

    public void play(boolean open) {
        try {
            URL u = this.getSound(open ? "door_open.wav" : "door_close.wav");
            if (u == null) {
                return;
            }
            Clip clip = AudioSystem.getClip();
            clip.open(AudioSystem.getAudioInputStream(u));
            clip.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean areYouSure() {
        if (this.modified) {
            int answer = JOptionPane.showConfirmDialog(null, "Do you want to save first?", "Unsaved changes", 1);
            if (answer == 2) {
                return false;
            }
            if (answer == 0) {
                if (this.save == null) {
                    this.saveOpenDialog(false, false);
                } else {
                    this.save();
                }
            }
        }
        return true;
    }

    private void save() {
        try {
            String s;
            if (this.playing) {
                this.playToggle();
            }
            if ((s = this.save.getAbsolutePath()).endsWith(".rdat")) {
                this.field.save(new File(s));
            } else {
                if (!s.endsWith(".schematic")) {
                    s = String.valueOf(s) + ".schematic";
                }
                LevelLoader.save(this, s);
            }
            this.modified = false;
            this.updateTitle();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.frame, ex.getMessage(), "Error", 0);
        }
    }

    private void export(File f) {
        try {
            ImageWriter wr = ImageIO.getImageWritersByFormatName("gif").next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(f);
            wr.setOutput(ios);
            wr.prepareWriteSequence(null);
            int i = 0;
            while (i < this.z) {
                BufferedImage bi = new BufferedImage((this.x * 9 + 1) * this.scale, (this.y * 9 + 1) * this.scale, 13, Colors.icm);
                BufferedImage back = new BufferedImage(bi.getWidth(), bi.getHeight(), 5);
                Graphics2D g = back.createGraphics();
                g.scale(this.scale, this.scale);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int j = 0;
                while (j < this.y) {
                    int k = 0;
                    while (k < this.x) {
                        if (this.field.g(k, j, i) != Blocks.shadow || Field.layers > 1 && !this.field.g(k, j, i + 1).air()) {
                            g.setColor(Colors.grid);
                            g.fillRect(k * 9, j * 9, 10, 10);
                            this.field.draw(k, j, i, g, new Rectangle(k * 9 + 1, j * 9 + 1, 8, 8), new Blocks[0]);
                        }
                        ++k;
                    }
                    ++j;
                }
                byte[] pix = ((DataBufferByte)back.getRaster().getDataBuffer()).getData();
                byte[] ind = new byte[pix.length / 3];
                byte[] baR = new byte[Colors.icm.getMapSize()];
                Colors.icm.getReds(baR);
                byte[] baG = new byte[Colors.icm.getMapSize()];
                Colors.icm.getGreens(baG);
                byte[] baB = new byte[Colors.icm.getMapSize()];
                Colors.icm.getBlues(baB);
                int j2 = 0;
                while (j2 < ind.length) {
                    byte n = 0;
                    int d = Integer.MAX_VALUE;
                    int k = 0;
                    while (k < baR.length) {
                        int dr = (baR[k] & 0xFF) - (pix[3 * j2 + 2] & 0xFF);
                        int dg = (baG[k] & 0xFF) - (pix[3 * j2 + 1] & 0xFF);
                        int db = (baB[k] & 0xFF) - (pix[3 * j2] & 0xFF);
                        int dc = dr * dr + dg * dg + db * db;
                        if (dc < d) {
                            n = (byte)k;
                            d = dc;
                        }
                        ++k;
                    }
                    ind[j2] = n;
                    ++j2;
                }
                bi.setData(Raster.createRaster(new PixelInterleavedSampleModel(0, bi.getWidth(), bi.getHeight(), 1, bi.getWidth(), new int[1]), new DataBufferByte(ind, ind.length), null));
                IIOMetadata m = wr.getDefaultImageMetadata(new ImageTypeSpecifier(bi), wr.getDefaultWriteParam());
                Node root = m.getAsTree(m.getNativeMetadataFormatName());
                Node n = root.getFirstChild();
                while (n != null) {
                    if (n.getNodeName().equals("GraphicControlExtension")) {
                        IIOMetadataNode gce = (IIOMetadataNode)n;
                        gce.setAttribute("userInputFlag", "FALSE");
                        gce.setAttribute("disposalMethod", "restoreToBackgroundColor");
                        gce.setAttribute("delayTime", "200");
                        break;
                    }
                    n = n.getNextSibling();
                }
                if (i == 0) {
                    IIOMetadataNode aes = new IIOMetadataNode("ApplicationExtensions");
                    IIOMetadataNode ae = new IIOMetadataNode("ApplicationExtension");
                    ae.setAttribute("applicationID", "NETSCAPE");
                    ae.setAttribute("authenticationCode", "2.0");
                    byte[] byArray = new byte[3];
                    byArray[0] = 1;
                    ae.setUserObject(byArray);
                    aes.appendChild(ae);
                    root.appendChild(aes);
                }
                m.setFromTree(m.getNativeMetadataFormatName(), root);
                wr.writeToSequence(new IIOImage(bi, null, m), null);
                ++i;
            }
            wr.endWriteSequence();
            ios.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveOpenDialog(boolean open, final boolean gif) {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(this.folder);
        fc.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                if (gif) {
                    return "GIF files (.gif)";
                }
                return "Supported File Types (.rdat, .schematic)";
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String s = f.getName().substring(f.getName().lastIndexOf(46) + 1);
                if (gif) {
                    return s.equals("gif");
                }
                return s.equals("rdat") || s.equals("schematic");
            }
        });
        if (open) {
            if (fc.showOpenDialog(this.frame) == 0) {
                try {
                    this.save = fc.getSelectedFile();
                    this.folder = this.save.getParentFile();
                    if (this.save.getName().endsWith("rdat")) {
                        this.field.load(this.save);
                    } else {
                        LevelLoader.load(this, this.save.getAbsolutePath());
                    }
                    this.modified = false;
                    this.updateTitle();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this.frame, ex.getMessage(), "Error", 0);
                }
            }
        } else if (fc.showSaveDialog(this.frame) == 0) {
            if (gif) {
                String s = fc.getSelectedFile().getAbsolutePath();
                if (!s.toLowerCase().endsWith(".gif")) {
                    s = String.valueOf(s) + ".gif";
                }
                this.export(new File(s));
            } else {
                this.save = fc.getSelectedFile();
                this.folder = this.save.getParentFile();
                this.save();
            }
        }
    }

    public void modify() {
        if (!this.modified) {
            this.modified = true;
            this.updateTitle();
        }
    }

    private void updateTitle() {
        String m = "";
        if (this.modified && !IS_MAC) {
            m = "*";
        }
        this.frame.setTitle(String.valueOf(m) + (this.save != null ? String.valueOf(this.save.getName()) + " - " : "") + title);
        if (IS_MAC) {
            this.frame.getRootPane().putClientProperty("windowModified", new Boolean(this.modified));
        }
    }

    public static void main(String[] args) throws Exception {
        new Viewport(30, 20, 7);
    }

    public class ButtonAction
    extends AbstractAction {
        public static final int NEW = 0;
        public static final int CLONE = 1;
        public static final int SAVE = 2;
        public static final int OPEN = 3;
        public static final int TICK = 4;
        public static final int TICKALL = 5;
        public static final int PLAYPAUSE = 6;
        public static final int LYR_UP = 7;
        public static final int LYR_DN = 8;
        public static final int ADJUST = 9;
        public static final int OPT = 10;
        public static final int CLONE_ESC = 11;
        public static final int ZOOM_IN = 12;
        public static final int ZOOM_OUT = 13;
        public static final int EXIT = 14;
        public static final int SAVEAS = 15;
        public static final int GIF = 16;
        public int vers;

        public ButtonAction(int v) {
            this.vers = v;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.doAction();
        }

        private void doAction() {
            switch (this.vers) {
                case 0: {
                    if (!Viewport.this.areYouSure()) {
                        return;
                    }
                    Viewport.this.modified = false;
                    Viewport.this.save = null;
                    Viewport.this.field = new Field(Viewport.this, 30, 20, 7);
                    Viewport.this.setSize(30, 20, 7);
                    Viewport.this.setLyr(0);
                    Viewport.this.recountRed();
                    int i = 0;
                    while (i < Viewport.this.palArr.length) {
                        if (Viewport.this.palArr[i] == Palette.wire) {
                            Viewport.this.pal = i;
                        }
                        ++i;
                    }
                    Viewport.this.view.repaint();
                    Viewport.this.pView.repaint();
                    Viewport.this.updateTooltip();
                    Viewport.this.updateTitle();
                    break;
                }
                case 3: {
                    if (!Viewport.this.areYouSure()) {
                        return;
                    }
                    Viewport.this.saveOpenDialog(true, false);
                    break;
                }
                case 2: {
                    if (Viewport.this.save != null) {
                        Viewport.this.save();
                        break;
                    }
                }
                case 15: {
                    Viewport.this.saveOpenDialog(false, false);
                    break;
                }
                case 16: {
                    Viewport.this.saveOpenDialog(false, true);
                    break;
                }
                case 1: {
                    Viewport.this.cloneMode = 1;
                    Viewport.this.clone = new int[6];
                    break;
                }
                case 4: {
                    if (Viewport.this.playing) break;
                }
                case 5: {
                    Viewport.this.field.tick();
                    Viewport.this.view.repaint();
                    break;
                }
                case 6: {
                    Viewport.this.playToggle();
                    break;
                }
                case 7: {
                    Viewport.this.lyr += 2;
                }
                case 8: {
                    Viewport.this.setLyr(Viewport.this.lyr - 1);
                    Viewport.this.view.repaint();
                    Viewport.this.updateTooltip();
                    break;
                }
                case 9: {
                    Viewport.this.adjF.setVisible(true);
                    break;
                }
                case 10: {
                    Viewport.this.optF.setVisible(true);
                    break;
                }
                case 11: {
                    Viewport.this.cloneMode = 0;
                    Viewport.this.clone = null;
                    Viewport.this.view.repaint();
                    break;
                }
                case 12: {
                    Viewport.this.addScale(1);
                    break;
                }
                case 13: {
                    Viewport.this.addScale(-1);
                    break;
                }
                case 14: {
                    if (!Viewport.this.areYouSure()) break;
                    System.exit(0);
                }
            }
        }
    }

    public class LAFActionListener
    implements ActionListener {
        String laf;

        public LAFActionListener(String s) {
            this.laf = s;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UIManager.setLookAndFeel(this.laf);
                SwingUtilities.updateComponentTreeUI(Viewport.this.frame);
                SwingUtilities.updateComponentTreeUI(Viewport.this.optF);
                SwingUtilities.updateComponentTreeUI(Viewport.this.adjF);
                Viewport.this.optF.pack();
                Viewport.this.adjF.pack();
            }
            catch (Exception ex) {
                ((Component)e.getSource()).setEnabled(false);
            }
        }
    }

    public class MissingIcon
    implements Icon {
        private int width;
        private int height;
        private BasicStroke stroke = new BasicStroke(4.0f);

        public MissingIcon(int w, int h) {
            this.width = w;
            this.height = h;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setColor(Color.WHITE);
            g2d.fillRect(x + 1, y + 1, this.width - 2, this.height - 2);
            g2d.setColor(Color.BLACK);
            g2d.drawRect(x + 1, y + 1, this.width - 2, this.height - 2);
            g2d.setColor(Color.RED);
            g2d.setStroke(this.stroke);
            double fac = 0.35;
            int wf = (int)((double)this.width * fac);
            int hf = (int)((double)this.height * fac);
            g2d.drawLine(x + wf, y + hf, x + this.width - wf, y + this.height - hf);
            g2d.drawLine(x + wf, y + this.height - hf, x + this.width - wf, y + hf);
            g2d.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    public class OptionAction
    implements ItemListener {
        public static final int CYCLIC = 0;
        public static final int NEW_WIRE = 1;
        public static final int DUMMY_SW = 2;
        public static final int LAYER1 = 3;
        public static final int LAYER3 = 4;
        public static final int BRIDGE = 5;
        public static final int WATER = 6;
        public int vers;

        public OptionAction(int v) {
            this.vers = v;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            switch (this.vers) {
                case 0: {
                    Field.cyclic = e.getStateChange() == 1;
                    Viewport.this.field.update();
                    break;
                }
                case 1: {
                    Field.MCwires = e.getStateChange() == 2;
                    break;
                }
                case 2: {
                    Field.dummyGdValve = e.getStateChange() == 2;
                    Viewport.this.field.update();
                    break;
                }
                case 3: {
                    if (e.getStateChange() == 1) {
                        Viewport.this.c3Lyr.setSelected(false);
                        Viewport.this.cBridge.setEnabled(false);
                        Viewport.this.cWater.setSelected(false);
                        Field.layers = 1;
                        Viewport.this.setPalette(Palette.pal1);
                        break;
                    }
                    Field.layers = 2;
                    Viewport.this.setPalette(Palette.pal2);
                    break;
                }
                case 4: {
                    if (e.getStateChange() == 1) {
                        Viewport.this.c1Lyr.setSelected(false);
                        Viewport.this.cBridge.setEnabled(true);
                        Viewport.this.cWater.setSelected(false);
                        Field.layers = 3;
                        Viewport.this.setPalette(Palette.pal3);
                        break;
                    }
                    Viewport.this.cBridge.setEnabled(false);
                    Field.layers = 2;
                    Viewport.this.setPalette(Palette.pal2);
                    break;
                }
                case 5: {
                    Field.bridge = e.getStateChange() == 1;
                    break;
                }
                case 6: {
                    waterMode = e.getStateChange() == 1;
                    if (waterMode) {
                        Viewport.this.c1Lyr.setSelected(false);
                        Viewport.this.c3Lyr.setSelected(false);
                        Viewport.this.cBridge.setEnabled(false);
                        Field.layers = 1;
                        Viewport.this.setPalette(Palette.waterP);
                        break;
                    }
                    Viewport.this.c1Lyr.setSelected(true);
                }
            }
            Viewport.this.view.repaint();
        }
    }

    public static class StatusBar
    extends JPanel {
        public StatusBar() {
            this.setLayout(new BoxLayout(this, 2));
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, 23));
            Color c = this.getBackground();
            if (c == null) {
                c = new Color(0xDDDDDD);
            }
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, c.darker().darker()), BorderFactory.createLineBorder(c.brighter())));
            super.add(Box.createHorizontalStrut(5));
        }

        public JSeparator addSeparator() {
            JPanel p = new JPanel(new BorderLayout());
            JSeparator s = new JSeparator(1);
            p.setMaximumSize(new Dimension(2, Integer.MAX_VALUE));
            p.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
            p.add(s);
            this.add(p);
            return s;
        }

        @Override
        public Component add(Component comp) {
            Component c = super.add(comp);
            super.add(Box.createHorizontalStrut(5));
            return c;
        }

        public void addGlue() {
            this.remove(this.getComponentCount() - 1);
            super.add(Box.createHorizontalGlue());
        }
    }
}

