/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.classes;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class BitImage {
    private final Color[][] image;
    private final int WIDTH;
    private final int HEIGTH;

    public static BitImage difference(BitImage org, BitImage to) {
        if (org == null || to == null || org.getHeight() != to.getHeight() || org.getWidth() != to.getWidth()) {
            return null;
        }
        BitImage ret = new BitImage(org.getWidth(), org.getHeight());
        boolean empty = true;
        for (int x = 0; x < org.getWidth(); ++x) {
            for (int y = 0; y < org.getHeight(); ++y) {
                if (org.get(x, y) == to.get(x, y)) continue;
                ret.set(x, y, org.get(x, y));
                empty = false;
            }
        }
        if (empty) {
            return null;
        }
        return ret;
    }

    public BitImage(int width, int height) {
        this(width, height, new Color(0, 0, 0, 0));
    }

    public BitImage(int width, int height, Color def) {
        this.WIDTH = width;
        this.HEIGTH = height;
        this.image = new Color[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                this.image[x][y] = def;
            }
        }
    }

    public BitImage(BitImage org) {
        this.HEIGTH = org.getHeight();
        this.WIDTH = org.getWidth();
        this.image = new Color[this.WIDTH][this.HEIGTH];
        for (int x = 0; x < this.WIDTH; ++x) {
            for (int y = 0; y < this.HEIGTH; ++y) {
                this.image[x][y] = org.get(x, y);
            }
        }
    }

    public BitImage addSpecial(BitImage img) {
        BitImage ret = new BitImage(img.getWidth(), img.getHeight());
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                if (img.get(x, y).getAlpha() <= 0 && img.get(x, y).getRGB() <= 0) continue;
                ret.set(x, y, this.get(x, y));
                this.set(x, y, img.get(x, y));
            }
        }
        return ret;
    }

    public void append(BitImage img) {
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                if (img.get(x, y).getAlpha() <= 0) continue;
                this.set(x, y, img.get(x, y));
            }
        }
    }

    public BitImage addAlpha(BitImage img) {
        return null;
    }

    public boolean isInside(int x, int y) {
        return this.isInside(new Point(x, y));
    }

    public boolean isInside(Point p) {
        return p.x >= 0 && p.x < this.getWidth() && p.y >= 0 && p.y < this.getHeight();
    }

    public void set(int x, int y, Color c) {
        this.image[x][y] = c;
    }

    public Color get(int x, int y) {
        return this.image[x][y];
    }

    public void shade(int x, int y, float ammount) {
        if (!this.isInside(x, y)) {
            return;
        }
        Color old = this.image[x][y];
        if (old.getAlpha() == 0) {
            return;
        }
        float[] ne = new float[3];
        Color.RGBtoHSB(old.getRed(), old.getBlue(), old.getGreen(), ne);
        ne[2] = Math.max(Math.min(1.0f, ne[2] + ammount), 0.0f);
        this.image[x][y] = Color.getHSBColor(-ne[0], ne[1], ne[2]);
    }

    public void drawLine(Point a, Point b, Color color) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void floodFill(int x, int y, Color replacement) {
        this.floodFill(x, y, replacement, this.image[x][y]);
    }

    private void floodFill(int x, int y, Color replacement, Color replace) {
        if (!this.isInside(x, y) || replacement.equals(replace)) {
            return;
        }
        if (this.image[x][y].equals(replace)) {
            this.image[x][y] = replacement;
            this.floodFill(x - 1, y, replacement, replace);
            this.floodFill(x + 1, y, replacement, replace);
            this.floodFill(x, y + 1, replacement, replace);
            this.floodFill(x, y - 1, replacement, replace);
        }
    }

    public BufferedImage getImage(float scale) {
        BufferedImage img = new BufferedImage((int)((float)this.getWidth() * scale), (int)((float)this.getHeight() * scale), 2);
        Graphics2D g = img.createGraphics();
        for (float x = 0.0f; x < (float)this.getWidth(); x += 1.0f) {
            for (float y = 0.0f; y < (float)this.getHeight(); y += 1.0f) {
                g.setColor(this.image[(int)x][(int)y]);
                g.fillRect((int)(x * scale), (int)(y * scale), (int)scale, (int)scale);
            }
        }
        g.dispose();
        return img;
    }

    public static BitImage getFromFile(URL url) {
        Image img = Toolkit.getDefaultToolkit().getImage(url);
        System.out.print("Loading image");
        while (img.getWidth(null) == -1 || img.getHeight(null) == -1) {
            System.out.print('.');
        }
        System.out.println(" Done!");
        int[] colors = new int[img.getWidth(null) * img.getHeight(null)];
        PixelGrabber g = new PixelGrabber(img, 0, 0, -1, -1, colors, 0, img.getWidth(null));
        try {
            System.out.print("Loading image... ");
            if (!g.grabPixels(0L)) {
                System.out.println("Failed!");
                return null;
            }
            System.out.println("Loaded!");
        }
        catch (InterruptedException ex) {
            System.out.println("Failed!");
            return null;
        }
        BitImage bit = new BitImage(g.getWidth(), g.getHeight());
        for (int x = 0; x < g.getWidth(); ++x) {
            for (int y = 0; y < g.getHeight(); ++y) {
                Color c = new Color(colors[y * g.getWidth() + x], true);
                bit.set(x, y, c);
            }
        }
        return bit;
    }

    public void saveToFile(final File file) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    ImageIO.write((RenderedImage)BitImage.this.getImage(2.0f), "png", file);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }).start();
    }

    public void alphaFix() {
        Color goodalpha = new Color(0, 0, 0, 0);
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                if (this.get(x, y).getAlpha() != 0) continue;
                this.set(x, y, goodalpha);
            }
        }
    }

    public int[] getImageAsPreviewArray() {
        BitImage com = new BitImage(this);
        if (!com.supportsMChat()) {
            com.removeMCHat();
        }
        com.removeMCAlpha();
        return this.getImageAsSingleArray(com);
    }

    public int[] getImageAsSingleArray() {
        return this.getImageAsSingleArray(this);
    }

    public int[] getImageAsSingleArray(BitImage img) {
        int[] ret = new int[img.getWidth() * img.getHeight()];
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                ret[x + y * img.getWidth()] = img.get(x, y).getRGB();
            }
        }
        return ret;
    }

    public boolean supportsMChat() {
        int y;
        int x;
        boolean headcomp = false;
        block0: for (x = 32; x < 64; ++x) {
            for (y = 8; y < 16; ++y) {
                if (this.get(x, y).getAlpha() != 0) continue;
                headcomp = true;
                continue block0;
            }
        }
        if (!headcomp) {
            block2: for (x = 40; x < 56; ++x) {
                for (y = 0; y < 8; ++y) {
                    if (this.get(x, y).getAlpha() != 0) continue;
                    headcomp = true;
                    continue block2;
                }
            }
        }
        return headcomp;
    }

    public void removeMCHat() {
        int y;
        int x;
        Color inv = new Color(0, 0, 0, 0);
        for (x = 32; x < 64; ++x) {
            for (y = 8; y < 16; ++y) {
                this.set(x, y, inv);
            }
        }
        for (x = 40; x < 56; ++x) {
            for (y = 0; y < 8; ++y) {
                this.set(x, y, inv);
            }
        }
    }

    public boolean isInsideMCHat(int x, int y) {
        return this.isInside(x, y) && (x >= 32 && y >= 8 && y < 16 || x >= 40 && x < 56 && y < 8);
    }

    public void removeMCAlpha() {
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 32; ++y) {
                Color c;
                if (this.isInsideMCHat(x, y) || (c = this.get(x, y)).getAlpha() >= 255) continue;
                this.set(x, y, Color.BLACK);
            }
        }
    }

    public int getWidth() {
        return this.WIDTH;
    }

    public int getHeight() {
        return this.HEIGTH;
    }
}

