/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.frames;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import swedtech.mcskinedit.classes.BitImage;
import swedtech.mcskinedit.classes.PNGFilenameFilter;
import swedtech.mcskinedit.classes.PickerListItem;
import swedtech.mcskinedit.frames.ProgramWindow;
import swedtech.mcskinedit.icons.ProgramIcon;
import swedtech.mcskinedit.panels.PreviewPane;

public class PartsPicker
implements ActionListener,
WindowListener {
    private final JDialog frame;
    private final JPanel main;
    private final JList used;
    private final JList avaible;
    private final DefaultListModel usedData;
    private final DefaultListModel avaibleData;
    private final PreviewPane prew;
    private final BitImage img;

    private PartsPicker(JFrame owner, BitImage img) {
        this.img = img;
        this.frame = new JDialog(owner, "SkinEdit PartsPicker", true);
        new Thread(new Runnable(){

            public void run() {
                PartsPicker.this.frame.setIconImages(ProgramIcon.getProgramIcons());
            }
        }).start();
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(this);
        this.main = new JPanel(new BorderLayout());
        this.usedData = new DefaultListModel();
        this.used = new JList(this.usedData);
        this.avaibleData = this.getAvaible();
        this.avaible = new JList(this.avaibleData);
        this.prew = new PreviewPane();
        JPanel buttonContainer = new JPanel(new GridLayout(0, 1, 2, 4));
        JButton add = new JButton("\u02c2");
        add.addActionListener(this);
        add.setActionCommand("add");
        buttonContainer.add(add);
        JButton remove = new JButton("\u02c3");
        remove.addActionListener(this);
        remove.setActionCommand("remove");
        buttonContainer.add(remove);
        JButton up = new JButton("\u02c4");
        up.addActionListener(this);
        up.setActionCommand("up");
        buttonContainer.add(up);
        JButton down = new JButton("\u02c5");
        down.addActionListener(this);
        down.setActionCommand("down");
        buttonContainer.add(down);
        JButton ok = new JButton("Ok");
        ok.addActionListener(this);
        ok.setActionCommand("ok");
        buttonContainer.add(ok);
        JButton close = new JButton("X");
        close.addActionListener(this);
        close.setActionCommand("close");
        buttonContainer.add(close);
        JScrollPane sUsed = new JScrollPane(this.used);
        JScrollPane sAvaible = new JScrollPane(this.avaible);
        sUsed.setPreferredSize(sAvaible.getPreferredSize());
        this.main.add((Component)sUsed, "West");
        this.main.add((Component)buttonContainer, "Center");
        this.main.add((Component)sAvaible, "East");
        JPanel extra = new JPanel(new BorderLayout());
        extra.add((Component)this.main, "West");
        extra.add((Component)this.prew, "East");
        this.frame.add(extra);
        this.frame.pack();
        this.prew.start();
        this.frame.setVisible(true);
    }

    private DefaultListModel getAvaible() {
        DefaultListModel<PickerListItem> def = new DefaultListModel<PickerListItem>();
        File folder = new File(ProgramWindow.LOCATION + File.separator + "parts" + File.separator);
        if (!folder.isDirectory()) {
            return def;
        }
        for (File f : folder.listFiles(new PNGFilenameFilter())) {
            def.addElement(new PickerListItem(f));
        }
        return def;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("add")) {
            int i = this.avaible.getSelectedIndex();
            if (i < 0) {
                return;
            }
            this.usedData.addElement(this.avaibleData.remove(i));
            this.used.setSelectedIndex(this.usedData.size() - 1);
            if (i == this.avaibleData.size()) {
                --i;
            }
            this.avaible.setSelectedIndex(i);
        } else if (cmd.equals("remove")) {
            int i = this.used.getSelectedIndex();
            if (i < 0) {
                return;
            }
            this.avaibleData.addElement(this.usedData.remove(i));
            if (i == this.usedData.size()) {
                --i;
            }
            this.used.setSelectedIndex(i);
        } else if (cmd.equals("up")) {
            int i = this.used.getSelectedIndex();
            if (i < 1) {
                return;
            }
            this.usedData.add(i - 1, this.usedData.remove(i));
            this.used.setSelectedIndex(i - 1);
        } else if (cmd.equals("down")) {
            int i = this.used.getSelectedIndex();
            if (i >= this.usedData.getSize() - 1) {
                return;
            }
            this.usedData.add(i + 1, this.usedData.remove(i));
            this.used.setSelectedIndex(i + 1);
        } else if (cmd.equals("close")) {
            if (JOptionPane.showConfirmDialog(this.frame, "Are you sure you want to close the window\n\nAll your added parts will be lost", "Confirm", 0, 3) == 0) {
                System.out.println("STOPPED");
                this.prew.stop();
                this.frame.dispose();
                this.usedData.clear();
            }
        } else if (cmd.equals("ok")) {
            System.out.println("STOPPED");
            this.prew.stop();
            this.frame.dispose();
        } else {
            System.err.println("Unknown actioncommand " + cmd);
        }
        this.updatePreview();
    }

    private BitImage getAllImages() {
        BitImage total = new BitImage(this.img.getWidth(), this.img.getHeight());
        for (int i = this.usedData.size() - 1; i >= 0; --i) {
            total.append(((PickerListItem)this.usedData.get(i)).getBitImage());
        }
        return total;
    }

    private void updatePreview() {
        BitImage total = new BitImage(this.img);
        total.append(this.getAllImages());
        this.prew.setImage(total.getImageAsSingleArray());
    }

    public static BitImage show(JFrame parent, BitImage bg) {
        PartsPicker p = new PartsPicker(parent, bg);
        return p.getAllImages();
    }

    public void windowClosing(WindowEvent e) {
        this.actionPerformed(new ActionEvent(this, 1, "close"));
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

