/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.panels;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import swedtech.mcskinedit.Launcher;
import swedtech.mcskinedit.classes.BitImage;
import swedtech.mcskinedit.classes.Settings;
import swedtech.mcskinedit.panels.PreviewPane;

public class EditArea
extends JComponent
implements MouseMotionListener,
MouseListener {
    private Image background;
    private Color color = Color.BLACK;
    private BitImage image = new BitImage(64, 32, new Color(255, 255, 255, 0));
    private double propX;
    private double propY;
    private int holding;
    private float bgalpha = 0.2f;
    private JColorChooser col = null;
    private static final Point OUTSIDE = new Point(-1, -1);
    private Point mouseLoc = OUTSIDE;
    private Point lastLoc = OUTSIDE;
    private boolean drawBgUnder;
    private byte brushsize = 1;
    private PreviewPane pre;
    private ArrayList<BitImage> undos;
    private ArrayList<BitImage> redos;
    private boolean saved = true;
    private JFrame mainframe;
    private File filename;
    private Color outsideColor = Color.BLACK;
    private boolean prewiewSimmulate = true;
    BitImage oldimage;

    public EditArea(JFrame mainframe, JColorChooser col, PreviewPane pre) throws MalformedURLException {
        this.mainframe = mainframe;
        this.col = col;
        this.pre = pre;
        this.reset();
        this.setBackground(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("background.png")));
        while (this.background.getWidth(this) == -1) {
        }
        this.setPreferredSize(new Dimension(this.background.getWidth(this), this.background.getHeight(this)));
        this.setBackground(Color.GRAY);
        this.propX = this.background.getWidth(this) / this.image.getWidth();
        this.propY = this.background.getHeight(this) / this.image.getHeight();
        this.undos = new ArrayList();
        this.redos = new ArrayList();
        this.setFocusable(true);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void setColorFromPoint(Point p) {
        int x = (int)((double)p.x / this.propX);
        int y = (int)((double)p.y / this.propY);
        if (x < 0 || x > this.getImage().getWidth() - 1 || y < 0 || y > this.getImage().getHeight() - 1) {
            return;
        }
        if (this.getImage().get(x, y).getAlpha() == 0) {
            return;
        }
        this.setColor(this.getImage().get(x, y));
        this.col.setColor(this.getImage().get(x, y));
    }

    public void process(Point p) {
        int x = (int)((double)p.x / this.propX);
        int y = (int)((double)p.y / this.propY);
        if (x < 0 || x > this.getImage().getWidth() - 1 || y < 0 || y > this.getImage().getHeight() - 1) {
            return;
        }
        for (int xx = Math.max(x - this.brushsize / 2, 0); xx < Math.min(x + this.brushsize / 2 + this.brushsize % 2, this.getImage().getWidth()); ++xx) {
            for (int yy = Math.max(y - this.brushsize / 2, 0); yy < Math.min(y + this.brushsize / 2 + this.brushsize % 2, this.getImage().getHeight()); ++yy) {
                this.getImage().set(xx, yy, this.color);
            }
        }
        this.repaint((int)((double)x * this.propX - (double)(this.brushsize / 2) * this.propX), (int)((double)y * this.propY - (double)(this.brushsize / 2) * this.propY), (int)this.propX * this.brushsize + this.brushsize % 2, (int)this.propY * this.brushsize + this.brushsize % 2);
        this.updatePreview();
    }

    public void clear(Point p) {
        Color org = this.color;
        this.color = new Color(255, 255, 255, 0);
        this.process(p);
        this.color = org;
    }

    public void paint(Graphics g) {
        g.setColor(this.getOutsideColor());
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.background.getWidth(this), this.background.getHeight(this));
        Graphics2D g2d = (Graphics2D)g;
        if (this.isDrawBgUnder()) {
            this.drawBG(g2d);
        }
        for (int x = 0; x < this.getImage().getWidth(); ++x) {
            for (int y = 0; y < this.getImage().getHeight(); ++y) {
                if (this.getImage().get(x, y).getTransparency() <= 0) continue;
                g.setColor(this.getImage().get(x, y));
                g.fillRect((int)((double)x * this.propX), (int)((double)y * this.propY), (int)this.propX, (int)this.propY);
            }
        }
        if (!this.isDrawBgUnder()) {
            this.drawBG(g2d);
        }
        if (!this.mouseLoc.equals(OUTSIDE)) {
            Composite temp = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.7f));
            g2d.setColor(this.color);
            g2d.fillRect((int)((double)this.mouseLoc.x * this.propX - (double)(this.brushsize / 2) * this.propX), (int)((double)this.mouseLoc.y * this.propY - (double)(this.brushsize / 2) * this.propY), (int)(this.propX * (double)this.brushsize), (int)(this.propY * (double)this.brushsize));
            g2d.setComposite(temp);
        }
        if (Launcher.DEBUG) {
            FontMetrics fm = this.getFontMetrics(g2d.getFont());
            g2d.setColor(Color.BLACK);
            g2d.drawString("DEVELOPER VERSION", 1, fm.getHeight() + 1);
            g2d.drawString("Not to be released", 1, fm.getHeight() * 2 + 1);
            g2d.setColor(Color.RED);
            g2d.drawString("DEVELOPER VERSION", 0, fm.getHeight());
            g2d.drawString("Not to be released", 0, fm.getHeight() * 2);
        }
    }

    private void drawBG(Graphics2D g2d) {
        if (this.bgalpha != 0.0f) {
            Composite temp = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, this.bgalpha));
            g2d.drawImage(this.background, 0, 0, this);
            g2d.setComposite(temp);
        }
    }

    public void reset() {
        for (int x = 0; x < this.getImage().getWidth(); ++x) {
            for (int y = 0; y < this.getImage().getHeight(); ++y) {
                this.getImage().set(x, y, new Color(255, 255, 255, 0));
            }
        }
        this.setFilename(null);
        this.repaint();
        this.updatePreview();
        this.setSaved(true);
    }

    public void updatePreview() {
        if (this.pre != null) {
            if (this.prewiewSimmulate) {
                this.pre.setImage(this.image.getImageAsPreviewArray());
            } else {
                this.pre.setImage(this.image.getImageAsSingleArray());
            }
        }
    }

    public void saveImage() {
        if (this.getFilename() == null) {
            this.showSaveImage();
            return;
        }
        this.saveImage(this.getFilename());
    }

    public boolean saveImage(File file) {
        try {
            boolean ret = ImageIO.write((RenderedImage)this.renderImage(), "png", file);
            this.setFilename(file);
            this.setSaved(true);
            return ret;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void showLoadImage() {
        JFileChooser fc = new JFileChooser(Settings.getInstance().getProperty("lastfilelocation", System.getProperty("user.dir")));
        if (fc.showOpenDialog(fc) != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, "The file doesn't exist.");
            return;
        }
        if (!file.canRead()) {
            JOptionPane.showMessageDialog(this, "The file exist but isn't readable.");
            return;
        }
        this.loadImage(file);
    }

    public void showNewImage() {
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to create a new image. All unsaved changes will be lost!", "Confirm", 0) == 0) {
            this.undos.clear();
            this.reset();
            this.updatePreview();
        }
    }

    public void showSaveImage() {
        JFileChooser fc = new JFileChooser(Settings.getInstance().getProperty("lastfilelocation", System.getProperty("user.dir")));
        if (fc.showSaveDialog(fc) != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        if (!file.getAbsolutePath().toLowerCase().endsWith(".png")) {
            System.out.println("Appended .png to the filename");
            file = new File(file.getAbsolutePath() + ".png");
        }
        if (file.canWrite() && JOptionPane.showConfirmDialog(this, "The file exists. Overwrite?", "Confirm", 0) != 0) {
            return;
        }
        if (file.exists() && !file.canWrite()) {
            JOptionPane.showMessageDialog(this, "The file already exists and can not be overwritten.");
            return;
        }
        this.setFilename(file);
        if (!this.saveImage(file)) {
            JOptionPane.showMessageDialog(this, "Error! Couldn't save file!");
        }
    }

    public boolean loadImage(File file) {
        try {
            Image load = Toolkit.getDefaultToolkit().createImage(file.toURI().toURL());
            while (load.getWidth(this) == -1) {
            }
            if (load.getWidth(this) != 64 || load.getHeight(this) != 32) {
                return false;
            }
            int[] pixels = new int[2048];
            PixelGrabber grabber = new PixelGrabber(load, 0, 0, 64, 32, pixels, 0, 64);
            grabber.grabPixels(0L);
            this.reset();
            for (int i = 0; i < 2048; ++i) {
                int yy = i / 64;
                this.getImage().set(i - yy * 64, yy, new Color(pixels[i], true));
            }
            this.setFilename(file);
            this.undos.clear();
            this.repaint();
            this.updatePreview();
            this.setSaved(true);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public BufferedImage renderImage() {
        BufferedImage save = new BufferedImage(64, 32, 2);
        Graphics2D g = save.createGraphics();
        for (int x = 0; x < this.getImage().getWidth(); ++x) {
            for (int y = 0; y < this.getImage().getHeight(); ++y) {
                g.setColor(this.getImage().get(x, y));
                g.fillRect(x, y, 1, 1);
            }
        }
        return save;
    }

    private void updateDot(Point p) {
        if (p.equals(OUTSIDE)) {
            this.mouseLoc = OUTSIDE;
            this.repaint((int)((double)this.lastLoc.x * this.propX - (double)(this.brushsize / 2) * this.propX), (int)((double)this.lastLoc.y * this.propY - (double)(this.brushsize / 2) * this.propY), (int)this.propX * this.brushsize + this.brushsize % 2, (int)this.propY * this.brushsize + this.brushsize % 2);
            this.lastLoc = this.mouseLoc;
            return;
        }
        Point temp = new Point((int)((double)p.x / this.propX), (int)((double)p.y / this.propY));
        if (!this.mouseLoc.equals(temp) || this.mouseLoc.equals(OUTSIDE)) {
            this.mouseLoc = temp;
            this.repaint((int)((double)temp.x * this.propX - (double)(this.brushsize / 2) * this.propX), (int)((double)temp.y * this.propY - (double)(this.brushsize / 2) * this.propY), (int)this.propX * this.brushsize, (int)this.propY * this.brushsize);
            this.repaint((int)((double)this.lastLoc.x * this.propX - (double)(this.brushsize / 2) * this.propX), (int)((double)this.lastLoc.y * this.propY - (double)(this.brushsize / 2) * this.propY), (int)this.propX * this.brushsize, (int)this.propY * this.brushsize);
            this.lastLoc = this.mouseLoc;
        }
    }

    public void createUndo(BitImage old) {
        this.createUndo(old, this.getImage());
    }

    public void createUndo(BitImage old, BitImage nev) {
        this.addUndoToList(BitImage.difference(old, nev));
    }

    private void addUndoToList(BitImage add) {
        if (add == null) {
            return;
        }
        this.redos.clear();
        this.undos.add(add);
    }

    public void undo() {
        try {
            BitImage undo = this.undos.remove(this.undos.size() - 1);
            this.redos.add(this.getImage().addSpecial(undo));
            this.getImage().addSpecial(undo);
            this.repaint();
            this.updatePreview();
        }
        catch (IndexOutOfBoundsException ex) {
            System.out.println("Nothing to undo!");
        }
    }

    public void redo() {
        try {
            BitImage redo = this.redos.remove(this.redos.size() - 1);
            this.undos.add(this.getImage().addSpecial(redo));
            this.getImage().addSpecial(redo);
            this.repaint();
            this.updatePreview();
        }
        catch (IndexOutOfBoundsException ex) {
            System.out.println("Nothing to redo!");
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setBackgroundAlpha(float a) {
        this.bgalpha = a;
        this.repaint();
    }

    public void setBackground(Image img) {
        while (img.getWidth(this) < 0 || img.getHeight(this) < 0) {
        }
        this.propX = img.getWidth(this) / this.getImage().getWidth();
        this.propY = img.getHeight(this) / this.getImage().getHeight();
        this.background = img;
        this.setPreferredSize(new Dimension(img.getWidth(this), img.getHeight(this)));
        this.repaint();
        this.mainframe.pack();
    }

    public void autoShade(float max) {
        Random r = new Random();
        BitImage be4 = new BitImage(this.getImage());
        for (int x = 0; x < this.getImage().getWidth(); ++x) {
            for (int y = 0; y < this.getImage().getHeight(); ++y) {
                float cur = r.nextFloat() * (max * 2.0f) - max;
                this.getImage().shade(x, y, cur);
            }
        }
        this.createUndo(be4);
        this.repaint();
        this.updatePreview();
    }

    public void mousePressed(MouseEvent e) {
        this.oldimage = new BitImage(this.getImage());
        this.setSaved(false);
        if (e.getButton() == 2) {
            this.setColorFromPoint(e.getPoint());
        }
        if (e.isAltDown()) {
            Point p = e.getPoint();
            int x = (int)((double)p.x / this.propX);
            int y = (int)((double)p.y / this.propY);
            if (e.getButton() == 1) {
                this.getImage().shade(x, y, e.isControlDown() ? 0.01f : 0.001f);
            } else if (e.getButton() == 3) {
                this.getImage().shade(x, y, e.isControlDown() ? -0.01f : -0.001f);
            }
            this.repaint((int)((double)(x - 1) * this.propX), (int)((double)(y - 1) * this.propY), (int)this.propX, (int)this.propY);
            this.updatePreview();
        } else if (e.isControlDown()) {
            if (e.getButton() == 1) {
                Point p = e.getPoint();
                this.getImage().floodFill((int)((double)p.x / this.propX), (int)((double)p.y / this.propY), this.color);
                this.repaint();
                this.updatePreview();
            } else if (e.getButton() == 3) {
                this.setColorFromPoint(e.getPoint());
            }
        } else if (e.getButton() == 1) {
            this.process(e.getPoint());
        } else if (e.getButton() == 3) {
            this.clear(e.getPoint());
        }
        this.holding = e.getButton();
    }

    public void mouseReleased(MouseEvent e) {
        this.createUndo(this.oldimage);
        this.oldimage = null;
        this.holding = -1;
    }

    public void mouseDragged(MouseEvent e) {
        if (e.isControlDown() && !e.isAltDown()) {
            return;
        }
        if (e.isAltDown()) {
            Point p = e.getPoint();
            int x = (int)((double)p.x / this.propX);
            int y = (int)((double)p.y / this.propY);
            if (this.holding == 1) {
                this.getImage().shade(x, y, e.isControlDown() ? 0.03f : 0.003f);
            } else if (this.holding == 3) {
                this.getImage().shade(x, y, e.isControlDown() ? -0.03f : -0.003f);
            }
            this.repaint((int)((double)(x - 1) * this.propX), (int)((double)(y - 1) * this.propY), (int)this.propX, (int)this.propY);
            this.updatePreview();
        } else if (this.holding == 1) {
            this.process(e.getPoint());
        } else if (this.holding == 3) {
            this.clear(e.getPoint());
        }
        this.updateDot(e.getPoint());
    }

    public void mouseMoved(MouseEvent e) {
        this.updateDot(e.getPoint());
    }

    public void mouseExited(MouseEvent e) {
        this.updateDot(OUTSIDE);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void setBrushsize(byte brushsize) {
        int oldsize = Math.max(brushsize, this.brushsize);
        this.brushsize = brushsize;
        this.repaint((int)((double)this.mouseLoc.x * this.propX - (double)(oldsize / 2) * this.propX), (int)((double)this.mouseLoc.y * this.propY - (double)(oldsize / 2) * this.propY), (int)(this.propX * (double)oldsize + (double)(oldsize % 2)), (int)(this.propY * (double)oldsize + (double)(oldsize % 2)));
    }

    public boolean isDrawBgUnder() {
        return this.drawBgUnder;
    }

    public void setDrawBgUnder(boolean drawBgUnder) {
        if (this.drawBgUnder != drawBgUnder) {
            this.drawBgUnder = drawBgUnder;
            this.repaint();
        }
    }

    public float getBackgroundAlpha() {
        return this.bgalpha;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        if (this.saved != saved) {
            this.mainframe.setTitle((!saved ? "* " : "") + Launcher.TITLE + (this.getFilename() != null ? " - " + this.getFilename().getName() : ""));
            this.saved = saved;
        }
    }

    public Color getOutsideColor() {
        return this.outsideColor;
    }

    public void setOutsideColor(Color outsideColor) {
        this.outsideColor = outsideColor;
        this.repaint();
    }

    public boolean isPrewiewSimmulate() {
        return this.prewiewSimmulate;
    }

    public void setPrewiewSimmulate(boolean prewiewSimmulate) {
        this.prewiewSimmulate = prewiewSimmulate;
    }

    public BitImage getImage() {
        return this.image;
    }

    public void setImage(BitImage image) {
        this.image = image;
    }

    public File getFilename() {
        return this.filename;
    }

    public void setFilename(File filename) {
        this.filename = filename;
        if (filename == null) {
            return;
        }
        try {
            Settings.getInstance().setProperty("lastfilelocation", filename.getParentFile().getCanonicalPath());
        }
        catch (IOException ex) {
            System.out.println("Failed to update dir settings!");
        }
    }
}

