/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.panels.color;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import swedtech.mcskinedit.panels.color.ColorSidePanel;

public class ColorChooser
extends JComponent
implements ActionListener,
MouseListener,
MouseMotionListener {
    private float h = 0.0f;
    private Color c = Color.RED;
    private Color c2 = Color.BLUE;
    private ArrayList<ActionListener> actionListeners = new ArrayList();
    private String actioncommand = "";

    public ColorChooser() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paint(Graphics g) {
        for (int i = 0; i < this.getSize().width; ++i) {
            for (int j = 0; j < this.getSize().height; ++j) {
                g.setColor(Color.getHSBColor(this.h, 1.0f - (float)i / (float)this.getSize().width, 1.0f - (float)j / (float)this.getSize().height));
                g.fillRect(i, j, 1, 1);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (!(e.getSource() instanceof ColorSidePanel)) {
            return;
        }
        this.h = ((ColorSidePanel)e.getSource()).getH();
        this.repaint();
    }

    private void setColor(MouseEvent e) {
        this.setColor(Color.getHSBColor(this.h, 1.0f - (float)e.getPoint().x / (float)this.getSize().width, 1.0f - (float)e.getPoint().y / (float)this.getSize().height), e.getButton() == 1);
    }

    public void setColor(Color c, boolean main) {
        this.c = c;
        for (ActionListener a : this.actionListeners) {
            a.actionPerformed(new ActionEvent(this, main ? 0 : 1, this.actioncommand));
        }
    }

    public Color getColor(boolean prim) {
        if (prim) {
            return this.c;
        }
        return this.c2;
    }

    public void addActionListener(ActionListener a) {
        this.actionListeners.add(a);
    }

    public void removeActionListener(ActionListener a) {
        this.actionListeners.remove(a);
    }

    public void clearActionListeners() {
        this.actionListeners.clear();
    }

    public void setActionCommand(String a) {
        this.actioncommand = a;
    }

    public void mousePressed(MouseEvent e) {
        this.setColor(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.setColor(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.setColor(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

