/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.panels.color;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JComponent;

public class ColorSidePanel
extends JComponent
implements MouseListener,
MouseMotionListener {
    private float h = 0.0f;
    private ArrayList<ActionListener> actionListeners = new ArrayList();
    private String actioncommand = "";

    public ColorSidePanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paint(Graphics g) {
        for (int i = 0; i < this.getSize().height; ++i) {
            g.setColor(Color.getHSBColor((float)i / (float)this.getSize().height, 1.0f, 1.0f));
            g.fillRect(0, i, this.getSize().width, 1);
        }
        g.setColor(Color.BLACK);
        g.drawRect(0, (int)(this.h * (float)this.getSize().height) - this.getSize().width / 6, this.getSize().width, this.getSize().width / 3);
    }

    private void setH(MouseEvent e) {
        this.setH((float)e.getPoint().y / (float)this.getSize().height);
    }

    public void setH(float h) {
        this.h = Math.min(1.0f, Math.max(h, 0.0f));
        for (ActionListener a : this.actionListeners) {
            a.actionPerformed(new ActionEvent(this, 0, this.actioncommand));
        }
        this.repaint();
    }

    public float getH() {
        return this.h;
    }

    public void addActionListener(ActionListener a) {
        this.actionListeners.add(a);
    }

    public void removeActionListener(ActionListener a) {
        this.actionListeners.remove(a);
    }

    public void clearActionListeners() {
        this.actionListeners.clear();
    }

    public void setActionCommand(String a) {
        this.actioncommand = a;
    }

    public void mousePressed(MouseEvent e) {
        this.setH(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.setH(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.setH(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

