/* gm_alchemist.sma is part of GabenMod
*  Copyright 2005-2006 by Basic-Master (AMX Mod X Dev Team)
*
*  Yes, Gabe, this mod is dedicated to you, we hope you like
*  it as much as we do! Nevertheless, VALVe, your code still
*  sucks. Especially your HL2SDK, it's a nightmare. Someday
*  Gaben will appear and eat you and your SDK >_<. HE WILL!
*
*/

#include <amxmodx>
#include <amxmisc>
#include <fakemeta>
#include <cstrike>
#include "gabenmod"
#if defined CSDM_COMPILATION
#include <csdm>
#endif

#define WALLS_REQP 49
#define LGTNG_UPGRADE_REQP 105
#define EXPL_CIRCLE_REQP 55
#define FMA_REQP 135
#define FREEZE_REQP 55

#define WALL_DIST 150
#define WALL_COUNT 2
#define WALL_MAX_COUNT 4
#define WALL_MINS Float:{ -88.0, -6.0, -19.0 }
#define WALL_MAXS Float:{  88.0,  6.0, 169.0 }

// note: this is damage per 0.1second!
#define LGTNG_RANGE 350
#define LGHTNG_DMG 6
#define UPGR_LGTNG_RANGE 650
#define UPGR_LGTNG_DMG 11

#define EXP_RADIUS 300.0
#define EXP_MAXDMG 350
#define EXP_MINDMG 5
#define EXP_COOLDOWN 20.0

#define FREEZE_RADIUS 450.0
#define FREEZE_SHOCKDMG 15
#define FREEZE_DURATION 3.5
#define FREEZE_COOLDOWN 19.0
#define FREEZE_MAXVEL 130.0

#define PLUGIN "GM Alchemist"
#define AUTHOR "Basic-Master"

#define AllKeys (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9) // Menu keys

new gHasClass[33]
new gCurrSound[33]
new gWalls[33][WALL_COUNT]
new Float:gWallHealth[33][WALL_COUNT] // for sound
new gWallOrigin[33][WALL_COUNT][3] // for fx
new gWallCount[33]

/* gSkills[0] = Walls
*  gSkills[1] = Lightning upgrade
*  gSkills[2] = Explosive Circle
*  gSkills[3] = Full Metal Armor
*  gSkills[4] = Freeze Ability
*/
new gSkills[33][5]
new gCanMakeExp[33], gUsingCircle[33]
new gCanFreeze[33]
new gBlock[33], gCanMove[33], gWallsBuilt[33]

new temp[256]
new Float:gSoundLength[9]
new gLightning, gShockwave, gExplosion
new mAlchemistmenu // Menu
new mcbAlchemistmenu // Menu Callback

new CsArmorType:de_armortype
new chk_players[32], chk_count, chk_player
new l_dmg, l_range, l_victim, CsTeams:l_team
new Float:l_fVec1[3], Float:l_fVec2[3], Float:l_fVec3[3]
new l_target[3], l_k, l_j, ds_tmp1, ds_tmp2, Float:l_health, l_sound[32], l_i
new Float:pt_fVec[3], pt_tmp1, pt_tmp2, pt_wpn

new gIsEnabled = 1

public plugin_init() {
	register_plugin(PLUGIN, GABENMOD_VERSION, AUTHOR)
	register_event("CurWeapon", "hook_wpn", "be")
	register_event("DeathMsg", "hook_death", "a")
	register_forward(FM_PlayerPreThink, "hook_prethink")
	register_forward(FM_ClientConnect, "hook_connect")
	/* Menu Alchemist menu */
	mAlchemistmenu = menu_create("Alchemist menu", "mh_Alchemistmenu")
	mcbAlchemistmenu = menu_makecallback("mcb_Alchemistmenu")
	menu_additem(mAlchemistmenu, "Build wall", "", ADMIN_ALL, mcbAlchemistmenu)
	menu_additem(mAlchemistmenu, "Destroy wall", "", ADMIN_ALL, mcbAlchemistmenu)
	menu_additem(mAlchemistmenu, "Explosive Circle", "", ADMIN_ALL, mcbAlchemistmenu)
	menu_additem(mAlchemistmenu, "Freeze", "", ADMIN_ALL, mcbAlchemistmenu)
	menu_additem(mAlchemistmenu, "Buy menu", "", ADMIN_ALL, mcbAlchemistmenu)
	/* Menu End */
	register_menucmd(register_menuid("BuyMenu"), AllKeys, "PressedBuyMenu")
	gm_RegClass("Alchemist", "Lightnings, powerful alchemist abilities", "cmd_init", "cmd_menu", "cmd_buy", 0)
	set_task(0.1, "lightning_check", 0, "", 0, "ab", 1)
	
	gIsEnabled = gm_IsEnabled()
}

public plugin_precache() {
	gLightning = engfunc(EngFunc_PrecacheModel, "sprites/lgtning.spr")
	gShockwave = engfunc(EngFunc_PrecacheModel, "sprites/shockwave.spr")
	gExplosion = engfunc(EngFunc_PrecacheModel, "sprites/explode1.spr")
	
	engfunc(EngFunc_PrecacheModel, "models/wall_n.mdl")
	engfunc(EngFunc_PrecacheModel, "models/wall_r.mdl")
	engfunc(EngFunc_PrecacheSound, "buttons/spark6.wav")
	
	// Precache the sounds...
	new tmp[40], i
	for(i=1;i<9;i++) {
		format(tmp, 39, "debris/zap%d.wav", i)
		engfunc(EngFunc_PrecacheSound, tmp)
	}
	engfunc(EngFunc_PrecacheSound, "debris/concrete1.wav")
	engfunc(EngFunc_PrecacheSound, "debris/concrete2.wav")
	engfunc(EngFunc_PrecacheSound, "debris/concrete3.wav")
	// .. and set their length
	gSoundLength[0] = 1.0
	gSoundLength[1] = 3.0
	gSoundLength[2] = 1.0
	gSoundLength[3] = 2.0
	gSoundLength[4] = 3.0
	gSoundLength[5] = 2.0
	gSoundLength[6] = 3.0
	gSoundLength[7] = 1.0
}


public cmd_init(id, hasclass) {
	gHasClass[id] = hasclass
	if (hasclass) {
		gCurrSound[id] = 0
		gCanMakeExp[id] = 1
		gCanFreeze[id] = 1
		gm_Respawn(id)
	}
	else {
		new Float:fOrigin[3], origin[3]
		for(new i=0;i<gWallCount[id];i++) {
			if (pev_valid(gWalls[id][i])) {
				if (gIsEnabled) {
					// effects, wtf
					pev(gWalls[id][i], pev_origin, fOrigin)
					origin[0] = floatround(fOrigin[0])
					origin[1] = floatround(fOrigin[1])
					origin[2] = floatround(fOrigin[2])
					kill_wall(origin)
				}
				// remove ent and stuff
				engfunc(EngFunc_RemoveEntity, gWalls[id][i])
				gWalls[id][i] = 0
			}
		}
		gWallCount[id] = 0
		gWallsBuilt[id] = 0
	}
	for(new i=0;i<5;i++)
		gSkills[id][i] = 0
}

public gm_UsingSkillCommand(id, skillid) {
	if (gIsEnabled && gHasClass[id] && skillid < 5 && gm_IsValidPlayer(id))
		mh_Alchemistmenu(id, mAlchemistmenu, skillid-1)
}

public hook_connect(id) {
	gCanMove[id] = 1
}

public gm_Respawn(id) {
	gCanMove[id] = 1
	gUsingCircle[id] = 0
	
	if (gBlock[id]) {
		if (is_user_connected(id))
			gm_SetRendering(id)
		gBlock[id] = 0
		remove_task(id+400)
	}
	
	if (!gIsEnabled || !gm_IsValidPlayer(id))
		return
	
	if (gHasClass[id]) {
		if (gSkills[id][3]) {
			set_user_health(id, 175.0)
			cs_set_user_armor(id, 200, CS_ARMOR_VESTHELM)
		}
		else {
			set_user_health(id, 110.0)
			cs_set_user_armor(id, 75, CS_ARMOR_VESTHELM)
		}
		
		if (!gCanMakeExp[id]) {
			gCanMakeExp[id] = 1
			remove_task(id+200)
		}
		if (!gCanFreeze[id]) {
			gCanFreeze[id]=  1
			remove_task(id+500)
		}
		
		set_task(0.1, "task_give", id)
		client_print(id, print_chat, "[GM] Switch to deagle and use +attack2 (rightclick) to fire a lightning.")
		engfunc(EngFunc_SetClientMaxspeed, id, 340.0)
		set_pev(id, pev_maxspeed, 340.0)
	}
}

public hook_death() {
	new id = read_data(2)
	if (gIsEnabled && gHasClass[id]) {
		new Float:fOrigin[3], origin[3]
		for(new i=0;i<gWallCount[id];i++) {
			if (pev_valid(gWalls[id][i])) {
				// effects, wtf
				pev(gWalls[id][i], pev_origin, fOrigin)
				origin[0] = floatround(fOrigin[0])
				origin[1] = floatround(fOrigin[1])
				origin[2] = floatround(fOrigin[2])
				kill_wall(origin)
				// remove ent and stuff
				engfunc(EngFunc_RemoveEntity, gWalls[id][i])
				gWalls[id][i] = 0
			}
		}
		gWallCount[id] = 0
		gWallsBuilt[id] = 0
	}
}

public task_give(id) {
	if (gIsEnabled) {
		gm_StripWeapons(id)
		/* Knife */
		gm_CreateOwnedItem(id, "weapon_knife")
		/* Deagle+ammo */
		gm_CreateOwnedItem(id, "weapon_deagle")
		gm_CreateOwnedItem(id, "ammo_50ae")
		gm_CreateOwnedItem(id, "ammo_50ae")
		gm_CreateOwnedItem(id, "ammo_50ae")
		/* Galil+ammo */
		gm_CreateOwnedItem(id, "weapon_galil")
		gm_CreateOwnedItem(id, "ammo_556nato")
		gm_CreateOwnedItem(id, "ammo_556nato")
		gm_CreateOwnedItem(id, "ammo_556nato")
	}
}

public hook_wpn(id) {
	if (gIsEnabled && gHasClass[id] && gm_IsValidPlayer(id)) {
		engfunc(EngFunc_SetClientMaxspeed, id, 340.0)
		set_pev(id, pev_maxspeed, 340.0)
	}
}

public hook_prethink(id) {
	if (gIsEnabled) {
		if (!gCanMove[id])
			set_pev(id, pev_velocity, { 0.0, 0.0, 0.0 })
		else if (gBlock[id]) {
			pev(id, pev_velocity, pt_fVec)
			if (pt_fVec[0] != 0.0)
				pt_fVec[0] = (1 / pt_fVec[0]) * FREEZE_MAXVEL
			if (pt_fVec[1] != 0.0)
				pt_fVec[1] = (1 / pt_fVec[1]) * FREEZE_MAXVEL
			if (pt_fVec[2] != 0.0)
				pt_fVec[2] = (1 / pt_fVec[2]) * FREEZE_MAXVEL
			set_pev(id, pev_velocity, pt_fVec)
		}
		
		if (gHasClass[id] && gm_IsValidPlayer(id)) {
			pt_wpn = get_user_weapon(id, pt_tmp1, pt_tmp2)
			if (!gCanMakeExp[id] && gUsingCircle[id]) {
				if (pt_wpn != CSW_KNIFE && pt_wpn != CSW_C4) {
					set_pev(id, pev_button, 0)
					engclient_cmd(id, "weapon_knife")
					set_pev(id, pev_velocity, Float:{ 0.0, 0.0, 0.0 })
					return FMRES_OVERRIDE
				}
			}
		}
	}
	
	return FMRES_HANDLED
}

public lightning_check() {
	if (!gIsEnabled) return
	
	get_players(chk_players, chk_count, "a")
	for(l_i=0;l_i<chk_count;l_i++) {
		chk_player = chk_players[l_i]
		l_team = cs_get_user_team(chk_player)
		if (gHasClass[chk_player] && (l_team == CS_TEAM_CT  || l_team == CS_TEAM_T)) {
			if (pev(chk_player, pev_button)&IN_ATTACK2 && deagleselected(chk_player)) {
				if (gSkills[chk_player][1]) {
					l_range = UPGR_LGTNG_RANGE
					l_dmg = UPGR_LGTNG_DMG
				}
				else {
					l_range = LGTNG_RANGE
					l_dmg = LGHTNG_DMG
				}
				get_user_origin(chk_player, l_target, 3)
				l_fVec3[0] = float(l_target[0])
				l_fVec3[1] = float(l_target[1])
				l_fVec3[2] = float(l_target[2])
				pev(chk_player, pev_origin, l_fVec2)
				get_user_aiming(chk_player, l_victim, l_k, l_range)
				
				if (vec_distance(l_fVec2, l_fVec3) > l_range) {
					gm_VelocityByAim(chk_player, l_range, l_fVec1)
					l_target[0] = floatround(floatadd(l_fVec1[0], l_fVec2[0]))
					l_target[1] = floatround(floatadd(l_fVec1[1], l_fVec2[1]))
					l_target[2] = floatround(floatadd(l_fVec1[2], l_fVec2[2]))
				}
				else if (l_victim == 0) {
					message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
					write_byte(9) // TE_SPARKS
					write_coord(l_target[0])
					write_coord(l_target[1])
					write_coord(l_target[2])
					message_end()
				}
				
				message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
				write_byte(1) // TE_BEAMENTPOINTS
				write_short(chk_player)
				write_coord(l_target[0]) 
				write_coord(l_target[1])
				write_coord(l_target[2])
				write_short(gLightning)
				write_byte(0)
				write_byte(1)
				write_byte(1)
				write_byte(25)
				write_byte(60)
				write_byte(150)
				write_byte(100)
				write_byte(255)
				write_byte(255)
				write_byte(0)
				message_end()
				
				if (gCurrSound[chk_player] == 0) {
					new snd = random_num(0, 7)
					new sndfile[40]
					gCurrSound[chk_player] = snd+1
					set_task(gSoundLength[snd], "task_resetsound", chk_player+100)
					
					format(sndfile, 39, "debris/zap%d.wav", snd+1)
					emit_sound(chk_player, CHAN_AUTO, sndfile, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
				}
				
				if (l_victim != 0) {
					if (is_user_connected(l_victim))
						gm_ExtraDamage(chk_player, l_victim, l_dmg, "lightning", (l_k == HIT_HEAD), DMG_ENERGYBEAM)
					else
						gm_FakeDamage(l_victim, "lightning", float(l_dmg), DMG_ENERGYBEAM)
				}
			}
			else if (gCurrSound[chk_player] != 0) {
				new sndfile[40]
				if (gCurrSound[chk_player])
					remove_task(chk_player+100)
				
				format(sndfile, 39, "debris/zap%d.wav", gCurrSound[chk_player])
				emit_sound(chk_player, CHAN_AUTO, sndfile, 0.0, ATTN_NORM, (1<<5), PITCH_NORM)
				gCurrSound[chk_player] = 0
			}
			// zomg let's abuse this loop for the wall function
			for(l_k=0;l_k<gWallCount[chk_player];l_k++) {
				if (!pev_valid(gWalls[chk_player][l_k])) {
					kill_wall(gWallOrigin[chk_player][l_k])
					gWallCount[chk_player]--
					for(l_j=l_k;l_j<gWallCount[chk_player];l_j++) {
						gWalls[chk_player][l_j] = gWalls[chk_player][l_j+1]
						gWallHealth[chk_player][l_j] = gWallHealth[chk_player][l_j+1]
						gWallOrigin[chk_player][l_j] = gWallOrigin[chk_player][l_j+1]
					}
				}
				else {
					pev(gWalls[chk_player][l_k], pev_health, l_health)
					if (floatcmp(gWallHealth[chk_player][l_k], l_health) != 0) {
						pev(gWalls[chk_player][l_k], pev_health, gWallHealth[chk_player][l_k])
						format(l_sound, 31, "debris/concrete%d.wav", random_num(1, 3))
						emit_sound(gWalls[chk_player][l_k], CHAN_BODY, l_sound, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
					}
				}
			}
		}
	}
}

public task_resetsound(id) {
	id -= 100
	gCurrSound[id] = 0
}

deagleselected(id) {
	return (get_user_weapon(id, ds_tmp1, ds_tmp2) == CSW_DEAGLE)
}

public cmd_menu(id) {
	if (!gIsEnabled) return
	
	if (!gm_IsValidPlayer(id)) {
		client_print(id, print_chat, "[GM] You must be alive to use this function!")
		return
	}
	
	menu_display(id, mAlchemistmenu, 0)
}

/* The menu... */

public mh_Alchemistmenu(id, menu, item) {
	if (!gIsEnabled) return
	
	if (!gm_IsValidPlayer(id)) {
		client_print(id, print_chat, "[GM] You must be alive to use this function!")
		return
	}
	
	switch (item) {
		case 0: { // Create wall
			if (!gSkills[id][0]) {
				client_print(id, print_chat, "[GM] You haven't bought this skill yet!")
				return
			}
			
			if (gWallCount[id] < WALL_COUNT) {
				if (gWallsBuilt[id] < WALL_MAX_COUNT) {
					new Float:tmp[3], Float:tmp2[3]
					new Float:mins[3], Float:maxs[3]
					new angle, Float:ftmp
					pev(id, pev_v_angle, tmp)
					angle = floatround(tmp[1])
					if (angle < 0)
						angle += 360
					if (angle > 180)
						angle -= 180
					
					new ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "func_wall"))
					set_pev(ent, pev_classname, "gm_wall")
					// calulate everything
					mins = WALL_MINS
					maxs = WALL_MAXS
					if (angle > 45 && angle < 135)
						engfunc(EngFunc_SetModel, ent, "models/wall_n.mdl")
					else {
						ftmp = mins[1]
						mins[1] = mins[0]
						mins[0] = ftmp
						ftmp = maxs[1]
						maxs[1] = maxs[0]
						maxs[0] = ftmp
						
						engfunc(EngFunc_SetModel, ent, "models/wall_r.mdl")
					}
					dllfunc(DLLFunc_Spawn, ent)
					// set sizes etc.
					engfunc(EngFunc_SetSize, ent, mins, maxs)
					set_pev(ent, pev_mins, mins)
					set_pev(ent, pev_maxs, maxs)
					set_pev(ent, pev_absmin, mins)
					set_pev(ent, pev_absmax, maxs)
					pev(id, pev_origin, tmp2)
					gm_VelocityByAim(id, 150, tmp)
					tmp2[0] += tmp[0]
					tmp2[1] += tmp[1]
					tmp2[2]  = floatsub(tmp2[2], 20.0)
					engfunc(EngFunc_SetOrigin, ent, tmp2)
					set_pev(ent, pev_movetype, MOVETYPE_FLY)
					set_pev(ent, pev_solid, SOLID_BBOX)
					set_pev(ent, pev_health, 200.0)
					set_pev(ent, pev_takedamage, 2.0)
					set_pev(ent, pev_owner, id)
					// and set important values
					gWalls[id][gWallCount[id]] = ent
					// these three lines are confusing
					gWallOrigin[id][gWallCount[id]][0] = floatround(tmp2[0])
					gWallOrigin[id][gWallCount[id]][1] = floatround(tmp2[1])
					gWallOrigin[id][gWallCount[id]][2] = floatround(tmp2[2])
					gWallCount[id]++
					gWallsBuilt[id]++
					client_print(id, print_chat, "[GM] Wall built.")
				}
				else
					client_print(id, print_chat, "[GM] Sorry, you've reached your limit of %d walls. You can use this ability again after your next respawn.", WALL_MAX_COUNT)
			}
			else
				client_print(id, print_chat, "[GM] You cannot build more than %d walls at once!", WALL_COUNT)
			cmd_menu(id)
		}
		case 1: { // Destroy wall
			if (!gSkills[id][0]) {
				client_print(id, print_chat, "[GM] You haven't bought this skill yet!")
				return
			}
			
			if (gWallCount[id] > 0) {
				new ent = gWalls[id][gWallCount[id]-1]
				if (pev_valid(ent)) {
					new Float:fOrigin[3], origin[3]
					pev(ent, pev_origin, fOrigin)
					origin[0] = floatround(fOrigin[0])
					origin[1] = floatround(fOrigin[1])
					origin[2] = floatround(fOrigin[2])
					kill_wall(origin)
					engfunc(EngFunc_RemoveEntity, ent)
					client_print(id, print_chat, "[GM] Removed your last-built wall successfully.")
				}
				else
					client_print(id, print_chat, "[GM] Your last-built wall doesn't exist any more...")
				gWallCount[id]--
				gWalls[id][gWallCount[id]] = 0
			}
			else
				client_print(id, print_chat, "[GM] You haven't build any walls yet!")
			cmd_menu(id)
		}
		case 2: { // Explosive Circle
			if (!gSkills[id][2]) {
				client_print(id, print_chat, "[GM] You haven't bought this skill yet!")
				return
			}
			
			if (gCanMakeExp[id]) {
				new data[4], Float:fVec[3]
				pev(id, pev_origin, fVec)
				data[0] = floatround(fVec[0])
				data[1] = floatround(fVec[1])
				data[2] = floatround(fVec[2])
				data[3] = id
				
				message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
				write_byte(14)
				write_coord(data[0])
				write_coord(data[1])
				write_coord(data[2])
				write_byte(floatround(EXP_RADIUS) / 2)
				write_byte(100)
				write_byte(10)
				message_end()
				
				message_begin(MSG_ONE, get_user_msgid("ScreenFade"), {0, 0, 0}, id)
				write_short(120) // duration in 0.01s
				write_short(120) // holdtime in 0.01s
				write_short(10) // fadetime in 0.01s
				write_byte(0) // r
				write_byte(0) // g
				write_byte(0) // b
				write_byte(200)	// alpha
				message_end()
				
				data[2] -= 35
				task_rings(data)
				set_task(0.2, "task_rings", 0, data, 4)
				set_task(0.4, "task_rings", 0, data, 4)
				set_task(0.6, "task_rings", 0, data, 4)
				set_task(0.8, "task_rings", 0, data, 4)
				set_task(1.0, "task_rings", 0, data, 4)
				set_task(1.3, "task_explode", 0, data, 4)
				
				set_pev(id, pev_takedamage, 0.0)
				gCanMakeExp[id] = 0
				gCanMove[id] = 0
				gUsingCircle[id] = 1
			}
			else
				client_print(id, print_chat, "[GM] Try again in a few seconds...")
		}
		case 3: { // Freeze
			if (!gSkills[id][4]) {
				client_print(id, print_chat, "[GM] You haven't bought this skill yet!")
				return
			}
			
			if (gCanFreeze[id]) {
				// Get some player info
				new origin[3]
				get_user_origin(id, origin)
				// Set glow
				gm_SetRendering(id, kRenderFxGlowShell, 40, 20, 200, kRenderTransColor, 200)
				// Make ring
				message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
				write_byte(21)
				write_coord(origin[0])
				write_coord(origin[1])
				write_coord(origin[2] -30)
				write_coord(origin[0])
				write_coord(origin[1])
				write_coord(origin[2] + (floatround(FREEZE_RADIUS) *2) -35)
				write_short(gShockwave)
				write_byte(0)
				write_byte(0)
				write_byte(2)
				write_byte(20)
				write_byte(0)
				write_byte(40)
				write_byte(20)
				write_byte(200)
				write_byte(200)
				write_byte(0)
				message_end()
				// Implosion effect
				message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
				write_byte(14)
				write_coord(origin[0])
				write_coord(origin[1])
				write_coord(origin[2])
				write_byte(floatround(FREEZE_RADIUS) / 3)
				write_byte(100)
				write_byte(10)
				message_end()
				// Screenfade
				message_begin(MSG_ONE, get_user_msgid("ScreenFade"), { 0, 0, 0 }, id)
				write_short(1<<10)
				write_short(1<<10)
				write_short(1<<5)
				write_byte(0)
				write_byte(0)
				write_byte(200)
				write_byte(20)
				message_end()
				// Freeze players
				gCanMove[id] = 0
				set_task(floatdiv(FREEZE_RADIUS, 1000.0), "task_freezeplayers", id+300)
				// Enable cooldown
				set_pev(id, pev_takedamage, 0.0)
				if (FREEZE_COOLDOWN > 0.0) {
					gCanFreeze[id] = 0
					set_task(FREEZE_COOLDOWN, "task_freezeset", id+500)
				}
			}
			else
				client_print(id, print_chat, "[GM] Try again in a few seconds...")
		}
		case 4: { // Buy menu
			cmd_buy(id)
		}
	}
}

// Explosive Circle -->

public task_rings(data[]) {
	if (!gIsEnabled || !gHasClass[data[3]])
		return
	
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(21)
	write_coord(data[0])
	write_coord(data[1])
	write_coord(data[2] + 5)
	write_coord(data[0])
	write_coord(data[1])
	write_coord(data[2] + (floatround(EXP_RADIUS) *2))
	write_short(gShockwave)
	write_byte(0)
	write_byte(0)
	write_byte(2)
	write_byte(20)
	write_byte(0)
	write_byte(255)
	write_byte(40)
	write_byte(40)
	write_byte(200)
	write_byte(0)
	message_end()
}

public task_explode(data[]) {
	if (!gIsEnabled || !gHasClass[data[3]])
		return
	
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(3)
	write_coord(data[0])
	write_coord(data[1])
	write_coord(data[2])
	write_short(gExplosion)
	write_byte(floatround(EXP_RADIUS) /4)
	write_byte(15)
	write_byte(0)
	message_end()
	
	new Float:fOrigin[3], Float:fOrigin2[3]
	new Float:dmg, ent
	fOrigin[0] = float(data[0])
	fOrigin[1] = float(data[1])
	fOrigin[2] = float(data[2])
	while((ent = engfunc(EngFunc_FindEntityInSphere, ent, fOrigin, EXP_RADIUS)) > 0) {
		if (ent != data[3]) {
			pev(ent, pev_origin, fOrigin2)
			dmg = floatdiv(float(vec_distance(fOrigin, fOrigin2)), EXP_RADIUS)
			dmg = floatsub(1.0, dmg)
			dmg = floatmul(dmg, float(EXP_MAXDMG))
			
			if (floatround(dmg) < EXP_MINDMG)
				dmg = float(EXP_MINDMG)
			
			if (is_user_connected(ent)) {
				message_begin(MSG_ONE, get_user_msgid("ScreenShake"), { 0, 0, 0 }, ent)
				write_short(1<<14)
				write_short(1<<13)
				write_short(1<<14)
				message_end()
				
				gm_ExtraDamage(data[3], ent, floatround(dmg), "explosive_circle", 0, DMG_MORTAR)
			}
			else
				gm_FakeDamage(ent, "explosive_circle", dmg, DMG_MORTAR)
		}
	}
	
	gCanMove[data[3]] = 1
	gUsingCircle[data[3]] = 0
	set_pev(data[3], pev_takedamage, 2.0)
	set_task(EXP_COOLDOWN, "task_resetexp", data[3]+200)
}

public task_resetexp(id) {
	id -= 200
	gCanMakeExp[id] = gHasClass[id]
	if (gm_IsValidPlayer(id) && gIsEnabled)
		client_print(id, print_chat, "[GM] You can now use Explosive Circle again.")
}

// <-- Freeze -->


public task_freezeplayers(id) {
	id -= 300
	gCanMove[id] = 1
	if (gm_IsValidPlayer(id) && gIsEnabled) {
		gm_SetRendering(id)
		emit_sound(id, CHAN_AUTO, "buttons/spark6.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		
		new origin[3], Float:fOrigin[3]
		new ent = 0
		get_user_origin(id, origin)
		fOrigin[0] = float(origin[0])
		fOrigin[1] = float(origin[1])
		fOrigin[2] = float(origin[2])
		while ((ent = engfunc(EngFunc_FindEntityInSphere, ent, fOrigin, FREEZE_RADIUS)) > 0) {
			if (ent != id && gm_IsValidPlayer(ent)) {
				if ((!get_cvar_num("mp_friendlyfire") && get_user_team(id) != get_user_team(ent)) || (get_cvar_num("mp_friendlyfire"))) {
					// A screenfade
					message_begin(MSG_ONE, get_user_msgid("ScreenFade"), { 0, 0, 0 }, ent)
					write_short(1<<floatround(FREEZE_DURATION*10))
					write_short(1<<floatround(FREEZE_DURATION*10))
					write_short(1<<5)
					write_byte(0)
					write_byte(0)
					write_byte(200)
					write_byte(20)
					message_end()
					// Set a task to free the player again
					if (gBlock[ent])
						remove_task(ent+400)
					set_task(FREEZE_DURATION, "task_unfreeze" ,ent+400)
					// Block moves
					gBlock[ent] = 1
					// Sound
					emit_sound(ent, CHAN_AUTO, "buttons/spark6.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
					// Glow effect
					gm_SetRendering(ent, kRenderFxGlowShell, 40, 20, 200, kRenderTransColor, 200)
					// Damage
					gm_ExtraDamage(id, ent, FREEZE_SHOCKDMG, "freezeshock", 0, DMG_FREEZE)
				}
			}
		}
		
		set_pev(id, pev_takedamage, 2.0)
	}
}

public task_unfreeze(id) {
	id -= 400
	gBlock[id] = 0
	if (is_user_connected(id) && gIsEnabled)
		gm_SetRendering(id)
}

public task_freezeset(id) {
	id -= 500
	gCanFreeze[id] = 1
	if (gm_IsValidPlayer(id) && gIsEnabled)
		client_print(id, print_chat, "[GM] You can now use the Freeze Ability again.")
}

public gm_DamageEvent(victim, attacker, weapon[], damage, extradamage) {
	if (gIsEnabled && attacker && !extradamage && is_user_connected(attacker) && gHasClass[victim] && containi(weapon, "weapon_") == 0 && get_user_health(victim) - damage > 0) {
		if (gSkills[victim][3] && random_num(1, 5) == 3 && cs_get_user_armor(victim, de_armortype) != 0) {
			// heal and
			new Float:health
			pev(victim, pev_health, health)
			set_pev(victim, pev_health, health+float(damage))
			// reflect damage
			gm_ExtraDamage(victim, attacker, damage, weapon[7], 0)
		}
	}
}

// <-- End

public mcb_Alchemistmenu(id, menu, item) {
	if (item < 2)
		return (gSkills[id][0] ? ITEM_ENABLED: ITEM_DISABLED)
	if (item == 2)
		return (gSkills[id][2] ? ITEM_ENABLED: ITEM_DISABLED)
	if (item == 3)
		return (gSkills[id][4] ? ITEM_ENABLED: ITEM_DISABLED)
	return ITEM_ENABLED
}

/* The buymenu */

public cmd_buy(id) {
	if (!gIsEnabled) return
	
	show_buymenu(id)
}

show_buymenu(id) {
	new keys = (1<<9)
	temp = "\yBuy menu^n^n"
	/* Walls */
	if (gSkills[id][0]) {
		add(temp, 255, "\w1. Drop Wall Ability^n")
		keys |= (1<<0)
	}
	else if (gm_GetPoints(id) >= WALLS_REQP) {
		addpointitem("\w1. Buy Wall Ability", WALLS_REQP)
		keys |= (1<<0)
	}
	else
		addpointitem("\d1. Buy Wall Ability", WALLS_REQP)
	/* Lightning upgrade */
	if (gSkills[id][1]) {
		add(temp, 255, "\w2. Drop Lightning upgrade^n")
		keys |= (1<<1)
	}
	else if (gm_GetPoints(id) >= LGTNG_UPGRADE_REQP) {
		addpointitem("\w2. Buy Lightning upgrade", LGTNG_UPGRADE_REQP)
		keys |= (1<<1)
	}
	else
		addpointitem("\d2. Buy Lightning upgrade", LGTNG_UPGRADE_REQP)
	/* Explosive Circle */
	if (gSkills[id][2]) {
		add(temp, 255, "\w3. Drop Explosive Circle^n")
		keys |= (1<<2)
	}
	else if (gm_GetPoints(id) >= EXPL_CIRCLE_REQP) {
		addpointitem("\w3. Buy Explosive Circle", EXPL_CIRCLE_REQP)
		keys |= (1<<2)
	}
	else
		addpointitem("\d3. Buy Explosive Circle", EXPL_CIRCLE_REQP)
	/* Full Metal Armor */
	if (gSkills[id][3]) {
		add(temp, 255, "\w4. Drop Full Metal Armor^n")
		keys |= (1<<3)
	}
	else if (gm_GetPoints(id) >= FMA_REQP) {
		addpointitem("\w4. Buy Full Metal Armor", FMA_REQP)
		keys |= (1<<3)
	}
	else
		addpointitem("\d4. Buy Full Metal Armor", FMA_REQP)
	/* Freeze */
	if (gSkills[id][4]) {
		add(temp, 255, "\w5. Drop Freeze Ability^n")
		keys |= (1<<4)
	}
	else if (gm_GetPoints(id) >= FREEZE_REQP) {
		addpointitem("\w5. Buy Freeze Ability", FREEZE_REQP)
		keys |= (1<<4)
	}
	else
		addpointitem("\d5. Buy Freeze Ability", FREEZE_REQP)
	
	add(temp, 255, "^n\w0. Exit")
	
	show_menu(id, keys, temp, -1, "BuyMenu") // Display menu
}

addpointitem(title[], points) {
	new tmp[64]
	format(tmp, 63, "%s (%d points)^n", title, points)
	add(temp, 255, tmp)
}

public PressedBuyMenu(id, key) {
	if (!gIsEnabled) return
	
	switch (key) {
		case 0: { // Walls
			if (gSkills[id][0]) {
				if (gWallsBuilt[id] == 0) {
					// remove every wall
					for(new i=0;i<gWallCount[id];i++) {
						if (pev_valid(gWalls[id][i])) {
							engfunc(EngFunc_RemoveEntity, gWalls[id][i])
							gWalls[id][i] = 0
						}
					}
					gWallCount[id] = 0
					gWallsBuilt[id] = 0
					// and then flags
					gm_AddPoints(id, WALLS_REQP)
					gSkills[id][0] = 0
					client_print(id, print_chat, "[GM] You've dropped Walls and got %d points back.", WALLS_REQP)
				}
				else
					client_print(id, print_chat, "[GM] You've already built walls, drop this skill after your next respawn.")
			}
			else if (gm_GetPoints(id) >= WALLS_REQP) {
				gm_RemPoints(id, WALLS_REQP)
				gSkills[id][0] = 1
				client_print(id, print_chat, "[GM] You've just bought Walls for %d points.", WALLS_REQP)
			}
		}
		case 1: { // Lightning upgrade
			if (gSkills[id][1]) {
				gm_AddPoints(id, LGTNG_UPGRADE_REQP)
				gSkills[id][1] = 0
				client_print(id, print_chat, "[GM] You've dropped Lightning upgrade and got %d points back.", LGTNG_UPGRADE_REQP)
			}
			else if (gm_GetPoints(id) >= LGTNG_UPGRADE_REQP) {
				gm_RemPoints(id, LGTNG_UPGRADE_REQP)
				gSkills[id][1] = 1
				client_print(id, print_chat, "[GM] You've just bought Lightning upgrade for %d points.", LGTNG_UPGRADE_REQP)
			}
		}
		case 2: { // Explosive Circle
			if (gSkills[id][2]) {
				gm_AddPoints(id, EXPL_CIRCLE_REQP)
				gSkills[id][2] = 0
				client_print(id, print_chat, "[GM] You've dropped Explosive Circle and got %d points back.", EXPL_CIRCLE_REQP)
			}
			else if (gm_GetPoints(id) >= EXPL_CIRCLE_REQP) {
				gm_RemPoints(id, EXPL_CIRCLE_REQP)
				gSkills[id][2] = 1
				client_print(id, print_chat, "[GM] You've just bought Explosive Circle for %d points.", EXPL_CIRCLE_REQP)
			}
		}
		case 3: { // Full Metal Armor
			if (gSkills[id][3]) {
				gm_AddPoints(id, FMA_REQP)
				gSkills[id][3] = 0
				client_print(id, print_chat, "[GM] You've dropped Full Metal Armor and got %d points back.", FMA_REQP)
			}
			else if (gm_GetPoints(id) >= FMA_REQP) {
				gm_RemPoints(id, FMA_REQP)
				gSkills[id][3] = 1
				client_print(id, print_chat, "[GM] You've just bought Full Metal Armor for %d points. You'll get it on your next respawn.", FMA_REQP)
			}
		}
		case 4: { // Freeze
			if (gSkills[id][4]) {
				gm_AddPoints(id, FREEZE_REQP)
				gSkills[id][4] = 0
				client_print(id, print_chat, "[GM] You've dropped the Freeze Ability and got %d points back.", FREEZE_REQP)
			}
			else if (gm_GetPoints(id) >= FREEZE_REQP) {
				gm_RemPoints(id, FREEZE_REQP)
				gSkills[id][4] = 1
				client_print(id, print_chat, "[GM] You've just bought the Freeze Ability for %d points.", FREEZE_REQP)
			}
		}
		case 9: {
			return
		}
	}
	show_buymenu(id)
}

kill_wall(origin[3]) {
	/* Some FX */
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(3)
	write_coord(origin[0])
	write_coord(origin[1])
	write_coord(origin[2])
	write_short(gExplosion)
	write_byte(25)
	write_byte(10)
	write_byte(0)
	message_end()
	
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(21)
	write_coord(origin[0])
	write_coord(origin[1])
	write_coord(origin[2] + 15)
	write_coord(origin[0])
	write_coord(origin[1])
	write_coord(origin[2] + 1000)
	write_short(gShockwave)
	write_byte(0)
	write_byte(0)
	write_byte(2)
	write_byte(20)
	write_byte(0)
	write_byte(190)
	write_byte(220)
	write_byte(255)
	write_byte(255)
	write_byte(0)
	message_end()
}

public gm_EnablingMod() {
	gIsEnabled = 1
}

public gm_DisablingMod() {
	gIsEnabled = 0
	
	new i, k
	new players[32], count
	get_players(players, count)
	for(i=0;i<count;i++) {
		gCanMove[players[i]] = 1
		
		if (gHasClass[players[i]]) {	
			if (gCurrSound[players[i]] != 0) {
				new sndfile[40]
				if (gCurrSound[players[i]])
					remove_task(players[i]+100)
					
				format(sndfile, 39, "debris/zap%d.wav", gCurrSound[players[i]])
				emit_sound(players[i], CHAN_AUTO, sndfile, 0.0, ATTN_NORM, (1<<5), PITCH_NORM)
				gCurrSound[players[i]] = 0
			}	
			
			for(k=0;i<gWallCount[players[i]];k++) {
				if (pev_valid(gWalls[players[i]][k])) {
					// remove ent and stuff
					engfunc(EngFunc_RemoveEntity, gWalls[players[i]][k])
					gWalls[players[i]][k] = 0
				}
			}
		}
	}
}
