/* gm_botsupport.sma is part of GabenMod [extension]
*  Copyright 2005-2006 by Basic-Master (AMX Mod X Dev Team)
*
*  Yes, Gabe, this mod is dedicated to you, we hope you like
*  it as much as we do! Nevertheless, VALVe, your code still
*  sucks. Especially your HL2SDK, it's a nightmare. Someday
*  Gaben will appear and eat you and your SDK >_<. HE WILL!
*
*  NOTE: All files must have their original name, otherwise
*  this plugin won't work!
*
*/

#include <amxmodx>
#include <amxmisc>
#include "gabenmod"
#include <cstrike>

#define PLUGIN "GM Bot Support"
#define AUTHOR "Basic-Master"

//#define LOG_BOT_ACTIONS

new g_BoughtSkills[33]
new g_ExtraInfo[33]
new g_RollthegabeLoaded

new g_IsEnabled = 1
new Float:pt_fVec[3]

public plugin_init() {
	register_plugin(PLUGIN, GABENMOD_VERSION, AUTHOR)
	register_forward(FM_ClientPutInServer, "hook_putinserver")
	register_forward(FM_PlayerPreThink, "hook_prethink")
	set_task(7.5, "task_performability")
	
	g_RollthegabeLoaded = (is_plugin_loaded("gm_engine.amxx"))
	
	g_IsEnabled = gm_IsEnabled()
}

public task_performability() {
	if (!g_IsEnabled) return
	
	new players[32], count, i
	get_players(players, count, "a")
	for(i=0;i<count;i++) {
		if (is_user_bot(players[i])) {
			if (random_num(1, 3) == 2)
				do_action(players[i])
			else
				check_buy(players[i])
			
			if (g_RollthegabeLoaded && gm_GetPoints(players[i]) > 150 && random_num(1, 3) == 1) {
				callfunc_begin("cmd_rollthegabe", "gm_rollthegabe.amxx")
				callfunc_push_int(players[i])
				callfunc_end()
				
				#if defined LOG_BOT_ACTIONS
				new name[32]
				get_user_name(players[i], name, 31)
				log_amx("Bot ^"%s^" used the rollthegabe function!", name)
				#endif
			}
		}
	}
	
	set_task(random_float(5.0, 15.0), "task_performability")
}

check_buy(id) {
	new class[32], reqp = -1
	gm_GetUserClass(id, class, 31)
	// Alchemist Class
	if (equal(class, "Alchemist")) {
		switch (g_BoughtSkills[id]) {
			case 0: reqp = 49
			case 1: reqp = 105
			case 2: reqp = 55
			case 3: reqp = 135
			case 4: reqp = 55
		}
		
		if (reqp != -1 && reqp <= gm_GetPoints(id)) {
			callfunc_begin("PressedBuyMenu", "gm_alchemist.amxx")
			callfunc_push_int(id)
			callfunc_push_int(g_BoughtSkills[id])
			callfunc_end()
			
			#if defined LOG_BOT_ACTIONS
			new name[32]
			get_user_name(id, name, 31)
			log_amx("Bot ^"%s^" (Alchemist) bought skill %d for %d points.", name, g_BoughtSkills[id], reqp)
			#endif
			
			g_BoughtSkills[id]++
		}
		return
	}
	// HWGuy
	if (equal(class, "HWGuy")) {
		switch (g_BoughtSkills[id]) {
			case 0: reqp = 14
			case 1: reqp = 35
			case 2: reqp = 49
			case 3: reqp = 21
			case 4: reqp = 35
			case 5: reqp = 70
			case 6: reqp = 56
		}
		
		if (reqp != -1 && reqp <= gm_GetPoints(id)) {
			callfunc_begin("PressedBuyMenu", "gm_hwguy.amxx")
			callfunc_push_int(id)
			callfunc_push_int(g_BoughtSkills[id])
			callfunc_end()
			
			#if defined LOG_BOT_ACTIONS
			new name[32]
			get_user_name(id, name, 31)
			log_amx("Bot ^"%s^" (HWGuy) bought skill %d for %d points.", name, g_BoughtSkills[id], reqp)
			#endif
			
			g_BoughtSkills[id]++
		}
		return
	}
	// Pyro
	if (equal(class, "Pyro")) {
		switch (g_BoughtSkills[id]) {
			case 0: reqp = 91
			case 1: reqp = 84
			case 2: reqp = 70
			case 3: reqp = 56
		}
		
		if (reqp != -1 && reqp <= gm_GetPoints(id)) {
			callfunc_begin("PressedBuyMenu", "gm_pyro.amxx")
			callfunc_push_int(id)
			callfunc_push_int(g_BoughtSkills[id])
			callfunc_end()
			
			#if defined LOG_BOT_ACTIONS
			new name[32]
			get_user_name(id, name, 31)
			log_amx("Bot ^"%s^" (Pyro) bought skill %d for %d points.", name, g_BoughtSkills[id], reqp)
			#endif
			
			g_BoughtSkills[id]++
		}
	}
	// Scout doesn't have a buymenu
	// Sniper
	if (equal(class, "Sniper")) {
		switch (g_ExtraInfo[id]) {
			case -1: reqp = 0
			case 0: reqp = 119
			case 1: reqp = 147
			case 2: reqp = 154
		}
		
		if (reqp != -1 && reqp <= gm_GetPoints(id, 0)) {
			g_ExtraInfo[id]++
			
			callfunc_begin("mh_SelectionMenu", "gm_sniper.amxx")
			callfunc_push_int(id)
			callfunc_push_int(g_ExtraInfo[id])
			callfunc_end()
		}
		
		reqp = -1
		switch (g_BoughtSkills[id]) {
			case 0: reqp = 70
			case 1: reqp = 55
			case 2: reqp = 35
			case 3: reqp = 65
		}
		
		if (reqp != -1 && reqp <= gm_GetPoints(id)) {
			callfunc_begin("PressedBuyMenu", "gm_sniper.amxx")
			callfunc_push_int(id)
			callfunc_push_int(g_BoughtSkills[id])
			callfunc_end()
			
			#if defined LOG_BOT_ACTIONS
			new name[32]
			get_user_name(id, name, 31)
			log_amx("Bot ^"%s^" (Sniper) bought skill %d for %d points.", name, g_BoughtSkills[id], reqp)
			#endif
			
			g_BoughtSkills[id]++
		}
	}
	// Soldier
	if (equal(class, "Soldier")) {
		switch (g_BoughtSkills[id]) {
			case 0: reqp = 65
			case 1: reqp = 90
			case 2: reqp = 114
			case 3: reqp = 56
			case 4: reqp = 50
			case 5: reqp = 21
		}
		
		if (reqp != -1 && reqp <= gm_GetPoints(id)) {
			callfunc_begin("PressedBuyMenu", "gm_soldier.amxx")
			callfunc_push_int(id)
			callfunc_push_int(g_BoughtSkills[id])
			callfunc_end()
			
			#if defined LOG_BOT_ACTIONS
			new name[32]
			get_user_name(id, name, 31)
			log_amx("Bot ^"%s^" (Soldier) bought skill %d for %d points.", name, g_BoughtSkills[id], reqp)
			#endif
			
			g_BoughtSkills[id]++
		}
	}
	// Spy
	if (equal(class, "Spy")) {
		switch (g_BoughtSkills[id]) {
			case 0: reqp = 50
			case 1: reqp = 50
			case 2: reqp = 65
			case 3: reqp = 45
			case 4: reqp = 70
			case 5: reqp = 50
		}
		
		if (reqp != -1 && reqp <= gm_GetPoints(id)) {
			callfunc_begin("PressedBuyMenu", "gm_spy.amxx")
			callfunc_push_int(id)
			callfunc_push_int(g_BoughtSkills[id])
			callfunc_end()
			
			#if defined LOG_BOT_ACTIONS
			new name[32]
			get_user_name(id, name, 31)
			log_amx("Bot ^"%s^" (Spy) bought skill %d for %d points.", name, g_BoughtSkills[id], reqp)
			#endif
			
			g_BoughtSkills[id]++
		}
	}
}

do_action(id) {
	new class[32]
	gm_GetUserClass(id, class, 31)
	if (equal(class, "Spy")) {
		switch (random_num(1, 3)) {
			case 1: { // Disguise
				if (cs_get_user_team(id) == CS_TEAM_CT) {
					callfunc_begin("mh_DisguseMenuCT", "gm_spy.amxx")
					callfunc_push_int(id)
					callfunc_push_int(0)
					callfunc_push_int(random_num(0, 3))
					callfunc_end()
					
					#if defined LOG_BOT_ACTIONS
					new name[32]
					get_user_name(id, name, 31)
					log_amx("Bot ^"%s^" disguised as a CT.", name)
					#endif
				}
				else {
					callfunc_begin("mh_DisguseMenuT", "gm_spy.amxx")
					callfunc_push_int(id)
					callfunc_push_int(0)
					callfunc_push_int(random_num(0, 3))
					callfunc_end()
					
					#if defined LOG_BOT_ACTIONS
					new name[32]
					get_user_name(id, name, 31)
					log_amx("Bot ^"%s^" disguised as a T.", name)
					#endif
				}
			}
			case 2: { // Feign
				call_skill(id, 3)	
			}
		}
	}
	else if (equal(class, "Alchemist"))
		call_skill(id, random_num(1, 4))
	else
		call_skill(id, random_num(1, 5)) // Unknown
}

public hook_putinserver(id) {
	g_BoughtSkills[id] = 0
	g_ExtraInfo[id] = -1
}

public hook_prethink(id) {
	if (g_IsEnabled && is_user_bot(id) && gm_IsValidPlayer(id)) {
		if (pev(id, pev_button)&IN_ATTACK && gm_AimingAtWall(id)) {
			gm_VelocityByAim(id, 2000, pt_fVec)				// looking at a wall is stupid
			set_pev(id, pev_velocity, pt_fVec)
			set_pev(id, pev_punchangle, Float:{ 360.0, 420.0, 360.0 }) 	// no hax for bots!
		}
	}
}

call_skill(id, skillid) {
	new func[32]
	/* Start */
	format(func, 31, "cmdStartSkill%d", skillid)
	callfunc_begin(func, "gm_engine.amxx")
	callfunc_push_int(id)
	callfunc_end()
	/* Stop */
	format(func, 31, "cmdStopSkill%d", skillid)
	callfunc_begin(func, "gm_engine.amxx")
	callfunc_push_int(id)
	callfunc_end()
	
	#if defined LOG_BOT_ACTIONS
	new name[32]
	get_user_name(id, name, 31)
	log_amx("Bot ^"%s^" tried to use skill %d.", name, skillid)
	#endif
}

public gm_EnablingMod() {
	g_IsEnabled = 1
}

public gm_DisablingMod() {
	g_IsEnabled = 0
}
