/* gm_rollthegabe.sma is part of GabenMod [extension]
*  Copyright 2005-2006 by Basic-Master (AMX Mod X Dev Team)
*
*  Yes, Gabe, this mod is dedicated to you, we hope you like
*  it as much as we do! Nevertheless, VALVe, your code still
*  sucks. Especially your HL2SDK, it's a nightmare. Someday
*  Gaben will appear and eat you and your SDK >_<. HE WILL!
*
*/

#include <amxmodx>
#include <amxmisc>
#include <fakemeta>
#include <cstrike>
#include "gabenmod"

#if defined CSDM_COMPILATION
#include <csdm>
#endif

#define RAGE_HURT_COOLDOWN 	0.5
#define RAGE_EXPLODE_COOLDOWN 	2.0

#define PLUGIN "GM RollTheGabe"
#define AUTHOR "Basic-Master"

new gCantRoll[33]

new mt_enemy
new pt_btn, pt_ent, Float:pt_time, pt_tmp1, pt_tmp2
new Float:pt_fVec[3], Float:pt_fVec2[3], Float:pt_fOut[3]
new Float:mt_fVec1[3], Float:mt_fVec2[3], Float:mt_fOut[3]

new gHasGodmode[33], gHasNoclip[33], gInRage[33]
new Float:gOldHealth[33]

new Float:gHurtTime[33]
new Float:gLastExplode[33]
new Float:gLastEffect[33]

new gTimeleft[33]
new gHyperSlapping[33]

new gExplosionSprite, gShockwave
new cRollPrice, cAlwaysPay

new gIsEnabled

public plugin_init() {
	register_plugin(PLUGIN, GABENMOD_VERSION, AUTHOR)
	
	register_forward(FM_PlayerPreThink, "hook_prethink")
	register_forward(FM_ClientDisconnect, "hook_disconnect")
	
	register_clcmd("say rollthegabe", "cmd_rollthegabe")
	register_clcmd("say rollthegaben", "cmd_rollthegabe")
	register_clcmd("say_team rollthegabe", "cmd_rollthegabe")
	register_clcmd("say_team rollthegaben", "cmd_rollthegabe")
	
	cRollPrice = register_cvar("gm_roll_price", "15")
	cAlwaysPay = register_cvar("gm_roll_alwayspay", "0")
	
	register_concmd("gm_killergabe", "cmd_killergabe", ADMIN_SLAY, "- Spawns a killergaben")
	register_concmd("gaben", "cmd_killergabe", ADMIN_SLAY, "- Spawns a killergaben")
	
	gIsEnabled = gm_IsEnabled()
	
	set_task(200.0, "task_rollthegabe_msg", 0, "", 0, "ab", 1)
}

public plugin_precache() {
	gExplosionSprite = engfunc(EngFunc_PrecacheModel, "sprites/fexplo.spr")
	gShockwave = engfunc(EngFunc_PrecacheModel, "sprites/shockwave.spr")
}

public hook_prethink(id) {
	if (!gIsEnabled || !gm_IsValidPlayer(id))
		return FMRES_IGNORED
	
	if (gHasNoclip[id] && pev(id, pev_movetype) != MOVETYPE_NOCLIP)
		set_pev(id, pev_movetype, MOVETYPE_NOCLIP)
	if (gHasGodmode[id])
		set_pev(id, pev_takedamage, 0.0)
	if (gInRage[id]) {
		if (get_user_weapon(id, pt_tmp1, pt_tmp2) != CSW_KNIFE)
			engclient_cmd(id, "weapon_knife")
		
		pt_btn = pev(id, pev_button)
		pev(id, pev_origin, pt_fVec)
		
		pt_time = Float:engfunc(EngFunc_Time)	// kids, never do that at home!
		
		if (pt_btn&IN_ATTACK) {
			pt_ent = 0
			
			while((pt_ent = engfunc(EngFunc_FindEntityInSphere, pt_ent, pt_fVec, 80.0)) > 0) {
				if (pt_ent != id && is_user_alive(pt_ent) && pt_time - gHurtTime[pt_ent] > RAGE_HURT_COOLDOWN) {
					if ((!get_cvar_num("mp_friendlyfire") && get_user_team(id) != get_user_team(pt_ent)) || (get_cvar_num("mp_friendlyfire"))) {
						pt_fVec[0] = random_float(-5.0, 5.0)
						pt_fVec[1] = random_float(-5.0, 5.0)
						pt_fVec[2] = random_float(-50.0, 50.0)
						
						set_pev(pt_ent, pev_punchangle, pt_fVec)
						emit_sound(pt_ent, CHAN_VOICE, "player/headshot2.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
						gm_ExtraDamage(id, pt_ent, 100, "knife", 1, DMG_BLAST)
						
						gHurtTime[pt_ent] = pt_time
					}
				}
			}
			
		}
		if (pt_btn&IN_ATTACK2 && pt_time - gLastExplode[id] > RAGE_EXPLODE_COOLDOWN) {
			pt_ent = 0
			pt_tmp1 = 0
			gLastExplode[id] = pt_time
			// explosion effect
			message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
			write_byte(3)
			write_coord(floatround(pt_fVec[0]))
			write_coord(floatround(pt_fVec[1]))
			write_coord(floatround(pt_fVec[2]))
			write_short(gExplosionSprite)
			write_byte(20)
			write_byte(25)
			write_byte(0)
			message_end()
			// beamcylinder
			message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
			write_byte(21)
			write_coord(floatround(pt_fVec[0]))
			write_coord(floatround(pt_fVec[1]))
			write_coord(floatround(pt_fVec[2]) + 15)
			write_coord(floatround(pt_fVec[0]))
			write_coord(floatround(pt_fVec[1]))
			write_coord(floatround(pt_fVec[2]) + 1000)
			write_short(gShockwave)
			write_byte(0)
			write_byte(0)
			write_byte(2)
			write_byte(20)
			write_byte(0)
			write_byte(190)
			write_byte(220)
			write_byte(255)
			write_byte(255)
			write_byte(0)
			message_end()
			// damage
			while((pt_ent = engfunc(EngFunc_FindEntityInSphere, pt_ent, pt_fVec, 120.0)) > 0) {
				if (pt_ent != id && is_user_alive(pt_ent) && pt_time - gHurtTime[pt_ent] > RAGE_HURT_COOLDOWN) {
					if ((!get_cvar_num("mp_friendlyfire") && get_user_team(id) != get_user_team(pt_ent)) || (get_cvar_num("mp_friendlyfire"))) {
						// punchangle, weee
						set_pev(pt_ent, pev_punchangle, { 0.0, 0.0, 100.0 })
						// sound
						emit_sound(pt_ent, CHAN_VOICE, "player/headshot2.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
						// velocity
						pev(pt_ent, pev_origin, pt_fVec2)
						pos_between_vectors(pt_fVec, pt_fVec2, 300.0, pt_fOut)
						pt_fOut[0] -= pt_fVec[0]
						pt_fOut[1] -= pt_fVec[1]
						pt_fOut[2] -= pt_fVec[2]
						set_pev(pt_ent, pev_velocity, pt_fOut)
						// damage
						gm_ExtraDamage(id, pt_ent, 350, "rage_explosion", 1, DMG_MORTAR)
						gHurtTime[pt_ent] = pt_time
						// effect
						pt_tmp1 = 1
					}
				}
			}
			if (pt_tmp1 && pt_time - gLastEffect[id] > 0.2) {
				// screenfade
				message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("ScreenFade"), {0, 0, 0}, id)
				write_short(60) // duration in 0.01s
				write_short(20) // holdtime in 0.01s
				write_short(40) // fadetime in 0.01s
				write_byte(0) // r
				write_byte(0) // g
				write_byte(0) // b
				write_byte(80)	// alpha
				message_end()
				
				gLastEffect[id] = pt_time
			}
		}
		
		if (pt_btn&IN_FORWARD && pt_btn&IN_BACK)
			return FMRES_HANDLED
		
		if (pt_btn&IN_FORWARD) {
			pev(id, pev_velocity, pt_fVec2)
			gm_VelocityByAim(id, 750, pt_fVec)
			pt_fVec[2] = pt_fVec2[2]
			set_pev(id, pev_velocity, pt_fVec)
			if (pt_time - gLastEffect[id] > 0.2) {
				message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("ScreenFade"), {0, 0, 0}, id)
				write_short(60) // duration in 0.01s
				write_short(20) // holdtime in 0.01s
				write_short(40) // fadetime in 0.01s
				write_byte(255) // r
				write_byte(0) // g
				write_byte(0) // b
				write_byte(50)	// alpha
				message_end()
				
				gLastEffect[id] = pt_time
			}
		}
		else if (pt_btn&IN_BACK) {
			pev(id, pev_velocity, pt_fVec2)
			gm_VelocityByAim(id, -750, pt_fVec)
			pt_fVec[2] = pt_fVec2[2]
			set_pev(id, pev_velocity, pt_fVec)
		}
	}
	
	return FMRES_IGNORED
}

public cmd_rollthegabe(id) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	if (gCantRoll[id]) {
		client_print(id, print_chat, "[GM] Try again in a few seconds...")
		return PLUGIN_CONTINUE
	}
	else if (!gm_IsValidPlayer(id)) {
		client_print(id, print_chat, "[GM] You must be alive to use this function!")
		return PLUGIN_CONTINUE
	}
	else if (gm_GetPoints(id, 1) < get_pcvar_num(cRollPrice)) {
		client_print(id, print_chat, "[GM] You don't have enough free points to use this function (costs %d points).", get_pcvar_num(cRollPrice))
		return PLUGIN_HANDLED
	}
	
	new random_gabe = random_num(1, 53)
	new nick[32], costs = get_pcvar_num(cAlwaysPay)
	get_user_name(id, nick, 31)
	#if defined KARMA_SUPPORTED
	if (random_num(1, 3) == 2 && random_gabe < 49) {
		new karma = get_user_karma(id)
		if (karma > 530)
			karma = 530
		else if (karma < 1)
			karma = 1
		random_gabe = random_num(floatround(karma / 530.0 * 53.0), 53)
	}
	#endif
	
	if (random_gabe < 10) {// Very bad, Gaben eats you
		new ent, Float:fVec[3], Float:fVec2[3]
		ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "env_sprite"))
		set_pev(ent, pev_classname, "gm_killergaben")
		set_pev(ent, pev_euser1, id)
		set_pev(ent, pev_movetype, MOVETYPE_NOCLIP)
		pev(id, pev_origin, fVec)
		gm_VelocityByAim(id, 1000, fVec2)
		fVec[0] += fVec2[0]
		fVec[1] += fVec2[1]
		fVec[2] += fVec2[2]
		engfunc(EngFunc_SetOrigin, ent, fVec)
		engfunc(EngFunc_SetModel, ent, "sprites/gaben.spr")
		set_keyvalue(ent, "scale", "0.6")
		
		
		set_task(0.1, "task_movethis", ent)
		client_print(0, print_chat, "** Bad luck, %s, Gaben is gonna eat you...", nick)
	}
	else if (random_gabe < 15) {  // Bad, Hyperslap
		new Float:fVec[3]
		// health
		set_pev(id, pev_health, 1.0)
		// punchangle
		fVec[0] = random_float(-900.0, 900.0)
		fVec[1] = random_float(-900.0, 900.0)
		fVec[2] = random_float(-900.0, 900.0)
		set_pev(id, pev_punchangle, fVec)
		// velocity
		fVec[0] = random_float(200.0, 3500.0)
		fVec[1] = random_float(200.0, 3500.0)
		fVec[2] = random_float(200.0, 3500.0)
		set_pev(id, pev_velocity, fVec)
		// temp godmode
		set_pev(id, pev_takedamage, 0.0)
		gHyperSlapping[id] = 1
		set_task(5.0, "task_nogod", id+200)
		// sound
		switch (random_num(1, 4)) {
			case 1: {
				emit_sound(id, CHAN_VOICE, "player/bhit_flesh-3.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
			}
			case 2: {
				emit_sound(id, CHAN_VOICE, "player/bhit_flesh-2.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
			}
			case 3: {
				emit_sound(id, CHAN_VOICE, "player/pl_die1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
			}
			case 4: {
				emit_sound(id, CHAN_VOICE, "player/pl_pain6.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
			}
		}
		// message
		client_print(0, print_chat, "** %s just got hyper-slapped!", nick)
	}
	else if (random_gabe < 18) { // Bury/Stuck, I think this is very bad ^^
		new Float:fVec[3]
		if (gm_AimingAtWall(id)) {
			pev(id, pev_origin, fVec)
			fVec[2] -= 50.0
			engfunc(EngFunc_SetOrigin, id, fVec)
			
			client_print(0, print_chat, "** %s has been buried!", nick)
		}
		else {
			new origin[3]
			get_user_origin(id, origin, 3)
			
			fVec[0] = float(origin[0])
			fVec[1] = float(origin[1])
			fVec[2] = float(origin[2])
			
			engfunc(EngFunc_SetOrigin, id, fVec)
			client_print(0, print_chat, "** %s got a new home inside a wall!", nick)
		}
	}
	else if (random_gabe < 21) { // Weapon Stripper
		new has_c4 = (user_has_weapon(id, CSW_C4) && cs_get_user_team(id) == CS_TEAM_T)
		new nid = engfunc(EngFunc_AllocString, "player_weaponstrip")
		new stripper = engfunc(EngFunc_CreateNamedEntity, nid)
		
		dllfunc(DLLFunc_Spawn, stripper)
		dllfunc(DLLFunc_Use, stripper, id)
		engfunc(EngFunc_RemoveEntity, stripper)
		
		if (has_c4) {
			gm_CreateOwnedItem(id, "weapon_c4")
			cs_set_user_plant(id, 1, 1)
		}
		gm_CreateOwnedItem(id, "weapon_knife")
		client_print(0, print_chat, "** %s lost all his weapons!", nick)
	}
	else if (random_gabe < 30) { // Glock
		gm_CreateOwnedItem(id, "weapon_glock18")
		cs_set_user_bpammo(id, CSW_GLOCK18, 90)
		client_print(0, print_chat, "** %s got a brand-new glock!", nick)
		
		costs = 1
	}
	else if (random_gabe < 37) { // MP5
		gm_CreateOwnedItem(id, "weapon_mp5navy")
		cs_set_user_bpammo(id, CSW_MP5NAVY, 120)
		client_print(0, print_chat, "** %s got a magic MP5 (not magic but it's cool)!", nick)
		
		costs = 1
	}
	else if (random_gabe < 24) { // Respawn
		dllfunc(DLLFunc_Spawn, id)
		client_print(0, print_chat, "** %s respawned!", nick)
	}
	else if (random_gabe < 43) { // Noclip
		set_pev(id, pev_movetype, MOVETYPE_NOCLIP)
		gHasNoclip[id] = 1
		client_print(0, print_chat, "** Watch out, %s has got noclip for 20 seconds!", nick)
		
		gTimeleft[id] = 20
		task_showtimeleft(id+300)
		
		costs = 1
	}
	else if (random_gabe < 49) { // Godmode for 30s
		gHasGodmode[id] = 1
		set_pev(id, pev_takedamage, 0.0)
		client_print(0, print_chat, "** Run as fast as you can - %s has godmode for 20 seconds!", nick)
		
		gTimeleft[id] = 20
		task_showtimeleft(id+300)
		
		costs = 1
	}
	else { // Rage
		pev(id, pev_health, gOldHealth[id])
		set_pev(id, pev_health, 255.0)
		gm_CreateOwnedItem(id, "weapon_knife")
		gInRage[id] = 1
		gm_SetRendering(id, kRenderFxGlowShell, 255, 0, 0, kRenderTransAlpha, 200)
		
		gTimeleft[id] = 20
		task_showtimeleft(id+300)
		client_print(0, print_chat, "** Killing time - %s is now in rage, get back into your spawns!", nick)
		
		costs = 1
	}
	
	if (costs)
		gm_RemPoints(id, get_pcvar_num(cRollPrice), 0) // costs something ^^
	gCantRoll[id] = 1
	set_task(30.0, "task_reset", id+100)
	return PLUGIN_HANDLED
}

public task_showtimeleft(id) {
	if (!gIsEnabled) return
	
	id -= 300
	if (is_user_alive(id)) {
		if (gTimeleft[id] == -1) {
			client_print(id, print_center, "")
			if (gHasNoclip[id])
				set_pev(id, pev_movetype, MOVETYPE_WALK)
			if (gHasGodmode[id])
				set_pev(id, pev_takedamage, 2.0)
			
			task_reset(id+100)
		}
		else {
			client_print(id, print_center, ".. %d ..", gTimeleft[id])
			gTimeleft[id]--
			set_task(1.0, "task_showtimeleft", id+300)
		}
	}
	else
		set_task(1.0, "task_showtimeleft", id+300)
}

public cmd_killergabe(id, level, cid) {
	if (!gIsEnabled) return PLUGIN_CONTINUE
	
	if (cmd_access(id, level, cid, 1)) {
		new target, arg[32]
		read_argv(1, arg, 31)
		remove_quotes(arg)
		
		target = cmd_target(id, arg, 7)
		if (target) {
			new nick[32], op[32]
			new ent, Float:fVec[3], Float:fVec2[3]
			get_user_name(target, nick, 31)
			
			ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "env_sprite"))
			set_pev(ent, pev_classname, "gm_killergaben")
			set_pev(ent, pev_euser1, target)
			set_pev(ent, pev_movetype, MOVETYPE_NOCLIP)
			pev(target, pev_origin, fVec)
			gm_VelocityByAim(target, 1000, fVec2)
			fVec[0] += fVec2[0]
			fVec[1] += fVec2[1]
			fVec[2] += fVec2[2]
			engfunc(EngFunc_SetOrigin, ent, fVec)
			engfunc(EngFunc_SetModel, ent, "sprites/gaben.spr")
			set_keyvalue(ent, "scale", "0.6")
			
			set_task(0.1, "task_movethis", ent)
			client_print(0, print_chat, "** Bad luck, %s, Gaben is gonna eat you...", nick)
			
			get_user_name(id, op, 31)
			log_amx("Admin ^"%s^" created a Gaben to kill ^"%s^".", op, nick)
		}
	}
	return PLUGIN_HANDLED
}

public hook_disconnect(id) {
	if (gCantRoll[id])
		remove_task(id+100)
	if (gHyperSlapping[id])
		remove_task(id+200)
	if (gTimeleft[id]) {
		remove_task(id+300)
		
		if (gHasNoclip[id])
			set_pev(id, pev_movetype, MOVETYPE_WALK)
		if (gHasGodmode[id])
			set_pev(id, pev_takedamage, 2.0)
	}
	
	task_reset(id+100)
}

public task_reset(id) {
	id -= 100
	
	if (gIsEnabled && gInRage[id])
		gm_SetRendering(id)
	
	gCantRoll[id] = 0
	gHasNoclip[id] = 0
	gHasGodmode[id] = 0
	gInRage[id] = 0
	gTimeleft[id] = 0
	gHyperSlapping[id] = 0
}

public task_movethis(id) {
	if (pev_valid(id)) {
		mt_enemy = pev(id, pev_euser1)
		if (gIsEnabled && is_user_connected(mt_enemy)) {
			pev(id, pev_origin, mt_fVec1)
			mt_fVec1[2] -= 45
			
			pev(mt_enemy, pev_origin, mt_fVec2)
			pos_between_vectors(mt_fVec1, mt_fVec2, 200.0, mt_fOut)
			mt_fOut[0] -= mt_fVec1[0]
			mt_fOut[1] -= mt_fVec1[1]
			mt_fOut[2] -= mt_fVec1[2]
			set_pev(id, pev_velocity, mt_fOut)
			if (vec_distance(mt_fVec1, mt_fVec2) < 100) {
				// nick
				new nick[32]
				get_user_name(mt_enemy, nick, 31)
				// sound, squatch!
				client_cmd(mt_enemy, "spk ^"player/headshot1.wav^"")
				user_kill(mt_enemy)
				// remove ent
				engfunc(EngFunc_RemoveEntity, id)
				// message
				client_print(0, print_chat, "** %s got killed by Gaben!", nick)
			}
			else
				set_task(0.1, "task_movethis", id)
		}
		else
			engfunc(EngFunc_RemoveEntity, id)
	}
}

public task_nogod(id) {
	id -= 200
	gHyperSlapping[id] = 0
	if (gm_IsValidPlayer(id))
		set_pev(id, pev_takedamage, 2.0)
}

public gm_EnablingMod() {
	gIsEnabled = 1
}

public gm_DisablingMod() {
	gIsEnabled = 0
	
	arrayset(gHyperSlapping, 0, 33)
	arrayset(gInRage, 0, 33)
	arrayset(gHasGodmode, 0, 33)
	arrayset(gHasNoclip, 0, 33)
}

public task_rollthegabe_msg() {
	if (gIsEnabled)
		client_print(0, print_chat, "** Say ^"rollthegabe^" to roll the gabe!")
}
