/* gm_soldier.sma is part of GabenMod
*  Copyright 2005-2006 by Basic-Master (AMX Mod X Dev Team)
*
*  Yes, Gabe, this mod is dedicated to you, we hope you like
*  it as much as we do! Nevertheless, VALVe, your code still
*  sucks. Especially your HL2SDK, it's a nightmare. Someday
*  Gaben will appear and eat you and your SDK >_<. HE WILL!
*
*/

#include <amxmodx>
#include <amxmisc>
#include <fakemeta>
#include <cstrike>
#include "gabenmod"
#if defined CSDM_COMPILATION
#include <csdm>
#endif

#define ROCKET_DELAY 0.5
#define ROCKET_RADIUS 150.0
#define ROCKET_MAXDMG 125.0
#define RELOAD_DELAY 1.8

#define MULTIROCKET_RADIUS 120.0
#define MULTIROCKET_MAXDMG 75.0

#define SPEED_REQP 65
#define MULTIEXP_REQP 90
#define RELOAD_REQP 114
#define AMMO_REQP 56
#define STRENGTH_REQP 50
#define CHICKEN_REQP 21

#define ROCKET_MINS Float:{ -1.0, -1.0, -1.0 }
#define ROCKET_MAXS Float:{  1.0,  1.0,  1.0 }
#define AllKeys (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9) // Menu keys
#define MAX_ENTS 1400

#define PLUGIN "GM Soldier"
#define AUTHOR "Basic-Master"

new gHasClass[33]
new gActionAllowed[33]

/* gSkills[0] = Extra Speed
*  gSkills[1] = Multi Explosion
*  gSkills[2] = Auto-Reload
*  gSkills[3] = Extra rockets
*  gSkills[4] = Strength (hp+armor)
*  gSkills[5] = Chicken rockets
*/
new gSkills[33][6]

/* 0 = Reloaded, ready to fire
*  1 = Reloading
*  2 = Canceled, reload on switch
*/
new gReloadStatus[33]
new gCurWeapon[33]
new gSteam, gExplosion, gShockwave
new gVRPG, gPRPG
new temp[256]
new Float:ht_fOrigin[3], ht_data[5], pt_button
new Float:rck_health
new hrs_tmp1, hrs_tmp2
new wpn_wpn, wpn_clip, wpn_ammo
new Float:pt_delay
new g_IsRocket[MAX_ENTS]
new g_IsEnabled = 1

public plugin_init() {
	register_plugin(PLUGIN, GABENMOD_VERSION, AUTHOR)
	register_event("CurWeapon", "hook_wpn", "b")
	register_forward(FM_PlayerPreThink, "hook_prethink")
	register_forward(FM_ClientPutInServer, "hook_putinserver")
	register_forward(FM_Touch, "hook_touch")
	
	gm_RegClass("Soldier", "Powerful RPG and Fa-mas", "cmd_init", "cmd_buy", "cmd_buy", 0)
	register_menucmd(register_menuid("BuyMenu"), AllKeys, "PressedBuyMenu")
	
	g_IsEnabled = gm_IsEnabled()
}

public plugin_precache() {
	engfunc(EngFunc_PrecacheSound, "weapons/357_cock1.wav")
	engfunc(EngFunc_PrecacheSound, "weapons/rocketfire1.wav")
	engfunc(EngFunc_PrecacheSound, "weapons/rocket1.wav")
	engfunc(EngFunc_PrecacheSound, "misc/killChicken.wav")
	
	engfunc(EngFunc_PrecacheModel, "models/v_rpg.mdl")
	engfunc(EngFunc_PrecacheModel, "models/p_rpg.mdl")
	engfunc(EngFunc_PrecacheModel, "models/rpgrocket.mdl")
	engfunc(EngFunc_PrecacheModel, "models/chick.mdl")
	gSteam = engfunc(EngFunc_PrecacheModel, "sprites/steam1.spr")
	gExplosion = engfunc(EngFunc_PrecacheModel, "sprites/explode1.spr")
	gShockwave = engfunc(EngFunc_PrecacheModel, "sprites/shockwave.spr")
	
	gVRPG = engfunc(EngFunc_AllocString, "models/v_rpg.mdl")
	gPRPG = engfunc(EngFunc_AllocString, "models/p_rpg.mdl")
}

public cmd_init(id, hasclass) {
	gHasClass[id] = hasclass
	if (hasclass && g_IsEnabled)
		gm_Respawn(id)
	
	for(new i=0;i<6;i++)
		gSkills[id][i] = 0
}

public cmd_buy(id) {
	if (g_IsEnabled)
		show_buymenu(id)
}

public gm_Respawn(id) {
	if (!g_IsEnabled || !gm_IsValidPlayer(id))
		return
	
	if (gHasClass[id]) {
		if (task_exists(id+100))
			remove_task(id+100)
		if (task_exists(id+200))
			remove_task(id+200)
		// armor
		if (gSkills[id][4]) {
			set_pev(id, pev_health, 130.0)
			cs_set_user_armor(id, 110, CS_ARMOR_VESTHELM)
		}
		else {
			set_pev(id, pev_health, 110.0)
			cs_set_user_armor(id, 35, CS_ARMOR_KEVLAR)
		}
		// speed
		if (gSkills[id][0]) {
			engfunc(EngFunc_SetClientMaxspeed, id, 350.0)
			set_pev(id, pev_maxspeed, 350.0)
		}
		else {
			engfunc(EngFunc_SetClientMaxspeed, id, 320.0)
			set_pev(id, pev_maxspeed, 320.0)
		}
		// weapons
		set_task(0.1, "task_give", id)
	}
}

has_rpg_selected(id) {
	return (get_user_weapon(id, hrs_tmp1, hrs_tmp2) == CSW_FLASHBANG)
}


public hook_prethink(id) {
	if (g_IsEnabled && gHasClass[id] && is_user_alive(id) && gCurWeapon[id] == CSW_FLASHBANG) {
		pt_button = pev(id, pev_button)
		if (pt_button&IN_ATTACK)
			set_pev(id, pev_button, pt_button&~IN_ATTACK)
		if (pev(id, pev_oldbuttons)&IN_ATTACK) {
			set_animation(id, 0)
			set_pev(id, pev_oldbuttons, pev(id, pev_oldbuttons)&~IN_ATTACK)
		}
		if (!gActionAllowed[id] || !gm_IsValidPlayer(id))
			return FMRES_HANDLED
		
		if (pt_button&IN_ATTACK) {
			pt_delay = ROCKET_DELAY
			if (cs_get_user_bpammo(id, CSW_FLASHBANG) != 0) {
				if (gReloadStatus[id] == 0) {
					set_pev(id, pev_punchangle, Float:{ -5.0, 0.0, 0.0 })
					set_animation(id, 3)
					cs_set_user_bpammo(id, CSW_FLASHBANG, cs_get_user_bpammo(id, CSW_FLASHBANG)-1)
					emit_sound(id, CHAN_WEAPON, "weapons/rocketfire1.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
					/* The rocket */
					new rocket = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_target"))
					set_pev(rocket, pev_classname, "gm_rocket")
					if (!gSkills[id][5])
						engfunc(EngFunc_SetModel, rocket, "models/rpgrocket.mdl")
					else {
						engfunc(EngFunc_SetModel, rocket, "models/chick.mdl")
						set_pev(rocket, pev_framerate, 25.0)
						set_pev(rocket, pev_frame, 0.0)
					}
					dllfunc(DLLFunc_Spawn, rocket)
					new Float:fVec[3]
					pev(id, pev_origin, fVec)
					fVec[2] = floatadd(fVec[2], 15.0)
					set_pev(rocket, pev_owner, id)
					engfunc(EngFunc_SetOrigin, rocket, fVec)
					pev(id, pev_v_angle, fVec)
					set_pev(rocket, pev_angles, fVec)
					engfunc(EngFunc_SetSize, rocket, ROCKET_MINS, ROCKET_MAXS)
					set_pev(rocket, pev_mins, ROCKET_MINS)
					set_pev(rocket, pev_maxs, ROCKET_MAXS)
					set_pev(rocket, pev_absmin, ROCKET_MINS)
					set_pev(rocket, pev_absmax, ROCKET_MAXS)
					set_pev(rocket, pev_solid, SOLID_BBOX)
					set_pev(rocket, pev_movetype, MOVETYPE_FLYMISSILE)
					set_pev(rocket, pev_health, 9999.0)
					set_pev(rocket, pev_takedamage, 2.0)
					set_task(0.1, "task_checkrocket", rocket+300)
					gm_VelocityByAim(id, 2000+get_ent_speed(id), fVec)
					set_pev(rocket, pev_velocity, fVec)
					emit_sound(rocket, CHAN_VOICE, "weapons/rocket1.wav", VOL_NORM, ATTN_NORM, 0, PITCH_HIGH)
					g_IsRocket[rocket] = 1
					/* Some fx */
					message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
					write_byte(22)
					write_short(rocket)
					write_short(gSteam)
					write_byte(10)
					write_byte(4)
					write_byte(200)
					write_byte(50)
					write_byte(50)
					write_byte(255)
					message_end()
					/* Player values */
					if (cs_get_user_bpammo(id, CSW_FLASHBANG) != 0 && !gSkills[id][2]) {
						gReloadStatus[id] = 1
						set_task(ROCKET_DELAY, "task_reload", id+200)
						pt_delay = floatadd(ROCKET_DELAY, RELOAD_DELAY)
						set_task(pt_delay, "task_reloadend", id+100)
					}
				}
			}
			else {
				if (is_user_bot(id)) // they rather commit suicide before they run out of ammo but who cares ^^
					client_cmd(id, "slot1")
				else
					emit_sound(id, CHAN_WEAPON, "weapons/357_cock1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
			}
			gActionAllowed[id] = 0
			set_task(pt_delay, "task_reset", id)
			return FMRES_SUPERCEDE
		}
	}
	return FMRES_IGNORED
}

set_animation(id, anim) {
	set_pev(id, pev_weaponanim, anim)
	
	message_begin(MSG_ONE, SVC_WEAPONANIM, {0, 0, 0}, id)
	write_byte(anim)
	write_byte(pev(id, pev_body))
	message_end()
}


public task_reset(id) {
	gActionAllowed[id] = 1
	hook_wpn(id)
}

public task_give(id) {
	if (!g_IsEnabled || !gHasClass[id] || !gm_IsValidPlayer(id))
		return
	
	gm_StripWeapons(id)
	gCurWeapon[id] = 0
	/* Knife */
	gm_CreateOwnedItem(id, "weapon_knife")
	/* USP */
	gm_CreateOwnedItem(id, "weapon_usp")
	gm_CreateOwnedItem(id, "ammo_45acp")
	gm_CreateOwnedItem(id, "ammo_45acp")
	gm_CreateOwnedItem(id, "ammo_45acp")
	/* FA-MAS */
	gm_CreateOwnedItem(id, "weapon_famas")
	gm_CreateOwnedItem(id, "ammo_556nato")
	gm_CreateOwnedItem(id, "ammo_556nato")
	/* Flashbang/RPG */
	gm_CreateOwnedItem(id, "weapon_flashbang")
	if (gSkills[id][3])
		cs_set_user_bpammo(id, CSW_FLASHBANG, 16)
	else
		cs_set_user_bpammo(id, CSW_FLASHBANG, 8)
	gReloadStatus[id] = 0
	gActionAllowed[id] = 1
	/* Switch to RPG */
	engclient_cmd(id, "weapon_flashbang")
}

public hook_wpn(id) {
	if (!g_IsEnabled || !gHasClass[id] || !gm_IsValidPlayer(id)) return PLUGIN_CONTINUE
	
	if (gSkills[id][0]) {
		engfunc(EngFunc_SetClientMaxspeed, id, 350.0)
		set_pev(id, pev_maxspeed, 350.0)
	}
	else {
		engfunc(EngFunc_SetClientMaxspeed, id, 320.0)
		set_pev(id, pev_maxspeed, 320.0)
	}
	
	wpn_wpn = get_user_weapon(id, wpn_clip, wpn_ammo)
	if (wpn_wpn == CSW_FLASHBANG) {
		if (gCurWeapon[id] != CSW_FLASHBANG) {
			gActionAllowed[id] = 2
			// MAGIC
			set_pev(id, pev_viewmodel, gVRPG)
			set_pev(id, pev_weaponmodel, gPRPG)
			
			if (gReloadStatus[id] == 2) {
				set_animation(id, 7)
				set_task(0.5, "task_reload", id+200)
				set_task(floatadd(RELOAD_DELAY, 0.5), "task_reloadend", id+100)
			}
			else
				set_animation(id, 5)
		}
	}
	else if (gCurWeapon[id] == CSW_FLASHBANG) {
		gActionAllowed[id] = 2
		set_task(0.5, "task_reset", id)
		if (gReloadStatus[id] == 1)
			gReloadStatus[id] = 2
		
		if (task_exists(id+100))
			remove_task(id+100)
		if (task_exists(id+200))
			remove_task(id+200)
	}
	gCurWeapon[id] = wpn_wpn
	
	return PLUGIN_CONTINUE
}

public task_reloadend(id) {
	id -= 100
	if (g_IsEnabled && is_user_alive(id) && has_rpg_selected(id)) {
		gReloadStatus[id] = 0
		set_animation(id, 0)
	}
}

public task_reload(id) {
	id -= 200
	if (g_IsEnabled && is_user_alive(id) && has_rpg_selected(id))
		set_animation(id, 2)
}

public task_checkrocket(id) {
	id -= 300
	if (g_IsRocket[id] && pev_valid(id)) {
		pev(id, pev_health, rck_health)
		if (rck_health < 9999.0 || !g_IsEnabled) {
			/* and the sound */
			emit_sound(id, CHAN_VOICE, "weapons/rocket1.wav", VOL_NORM, ATTN_NORM, (1<<5) /* SND_STOP */, PITCH_HIGH)
			/* Some damage and gabaction */
			g_IsRocket[id] = 0
			set_pev(id, pev_takedamage, 0.0)
			set_pev(id, pev_movetype, MOVETYPE_NONE)
			set_pev(id, pev_velocity, { 0.0, 0.0, 0.0 })
			engfunc(EngFunc_SetModel, id, "")
			pev(id, pev_origin, ht_fOrigin)
			ht_data[0] = floatround(ht_fOrigin[0])
			ht_data[1] = floatround(ht_fOrigin[1])
			ht_data[2] = floatround(ht_fOrigin[2])
			ht_data[3] = id
			if (gSkills[pev(id, pev_owner)][1]) { // Extra explosions
				ht_data[4] = 0
				rocket_dmg(ht_data)
				set_task(0.5, "rocket_dmg", 0, ht_data, 5)
				set_task(1.0, "rocket_dmg", 0, ht_data, 5)
				set_task(1.5, "rocket_dmg", 0, ht_data, 5)
				ht_data[4] = 1
				set_task(2.0, "rocket_dmg", 0, ht_data, 5)
			}
			else {
				ht_data[4] = 2
				rocket_dmg(ht_data)
			}
		}
		else
			set_task(0.1, "task_checkrocket", id+300)
	}
}

public hook_touch(ptr, ptd) {
	if (g_IsEnabled && g_IsRocket[ptr]) {
		/* Stop sound */
		emit_sound(ptr, CHAN_VOICE, "weapons/rocket1.wav", VOL_NORM, ATTN_NORM, (1<<5) /* SND_STOP */, PITCH_HIGH)
		/* Some damage and gabaction */
		g_IsRocket[ptr] = 0 // ow, and I forgot this line...
		set_pev(ptr, pev_takedamage, 0.0)
		set_pev(ptr, pev_movetype, MOVETYPE_NONE)
		set_pev(ptr, pev_velocity, { 0.0, 0.0, 0.0 })
		engfunc(EngFunc_SetModel, ptr, "")
		pev(ptr, pev_origin, ht_fOrigin)
		ht_data[0] = floatround(ht_fOrigin[0])
		ht_data[1] = floatround(ht_fOrigin[1])
		ht_data[2] = floatround(ht_fOrigin[2])
		ht_data[3] = ptr
		if (gSkills[pev(ptr, pev_owner)][1]) { // Extra explosions
			ht_data[4] = 0
			rocket_dmg(ht_data)
			set_task(0.5, "rocket_dmg", 0, ht_data, 5)
			set_task(1.0, "rocket_dmg", 0, ht_data, 5)
			set_task(1.5, "rocket_dmg", 0, ht_data, 5)
			ht_data[4] = 1
			set_task(2.0, "rocket_dmg", 0, ht_data, 5)
		}
		else {
			ht_data[4] = 2
			rocket_dmg(ht_data)
		}
		/* remove check task */
		remove_task(ptr+300)
	}
	
	return FMRES_HANDLED
}

public rocket_dmg(data[]) {
	if (!g_IsEnabled  || !pev_valid(data[3]))
		return
	
	new Float:fOrigin[3], Float:fOrigin2[3]
	new Float:dmg, ent, hasmulti = 0, owner
	fOrigin[0] = float(data[0])
	fOrigin[1] = float(data[1])
	fOrigin[2] = float(data[2])
	owner = pev(data[3], pev_owner)
	hasmulti = owner
	if (is_user_connected(hasmulti))
		hasmulti = gSkills[hasmulti][1]
	else {
		if (data[4] != 0)
			engfunc(EngFunc_RemoveEntity, data[3])
		return
	}
	
	while((ent = engfunc(EngFunc_FindEntityInSphere, ent, fOrigin, hasmulti ? MULTIROCKET_RADIUS: ROCKET_RADIUS)) > 0) {
		pev(ent, pev_origin, fOrigin2)
		dmg = floatdiv(float(vec_distance(fOrigin, fOrigin2)), hasmulti ? MULTIROCKET_RADIUS: ROCKET_RADIUS)
		dmg = floatsub(1.0, dmg)
		dmg = floatmul(dmg, hasmulti ? MULTIROCKET_MAXDMG: ROCKET_MAXDMG)
		
		if (floatcmp(1.0, dmg) == 1)
			dmg = 1.0
		
		if (is_user_connected(ent)) {
			if (owner == ent || (!get_cvar_num("mp_friendlyfire") && cs_get_user_team(owner) != cs_get_user_team(ent)) || (get_cvar_num("mp_friendlyfire"))) {
				message_begin(MSG_ONE, get_user_msgid("ScreenShake"), { 0, 0, 0 }, ent)
				write_short(1<<14)
				write_short(1<<13)
				write_short(1<<14)
				message_end()
				
				gm_ExtraDamage(owner, ent, floatround(dmg), "rocket", 0, DMG_MORTAR)
			}
		}
		else
			gm_FakeDamage(ent, "rocket", dmg, DMG_MORTAR)
	}
	/* FX */
	new origin[3]
	origin[0] = floatround(fOrigin[0])
	origin[1] = floatround(fOrigin[1])
	origin[2] = floatround(fOrigin[2])
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(3)
	write_coord(origin[0])
	write_coord(origin[1])
	write_coord(origin[2])
	write_short(gExplosion)
	write_byte(25)
	write_byte(10)
	write_byte(0)
	message_end()
	
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(21)
	write_coord(origin[0])
	write_coord(origin[1])
	write_coord(origin[2] + 15)
	write_coord(origin[0])
	write_coord(origin[1])
	write_coord(origin[2] + 1000)
	write_short(gShockwave)
	write_byte(0)
	write_byte(0)
	write_byte(2)
	write_byte(20)
	write_byte(0)
	write_byte(190)
	write_byte(220)
	write_byte(255)
	write_byte(255)
	write_byte(0)
	message_end()
	
	/* Play killChicken.wav and/or remove ent if it's the last explosion */
	if (gSkills[pev(data[3], pev_owner)][5])
		emit_sound(data[3], CHAN_VOICE, "misc/killChicken.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
	if (data[4] != 0)
		engfunc(EngFunc_RemoveEntity, data[3])
}

show_buymenu(id) {
	new keys = (1<<9)
	temp = "\yBuy menu^n^n"
	/* Extra Speed */
	if (gSkills[id][0]) {
		add(temp, 255, "\w1. Drop Extra Speed^n")
		keys |= (1<<0)
	}
	else if (gm_GetPoints(id) >= SPEED_REQP) {
		addpointitem("\w1. Buy Extra Speed", SPEED_REQP)
		keys |= (1<<0)
	}
	else
		addpointitem("\d1. Buy Extra Speed", SPEED_REQP)
	/* Multi Explosion */
	if (gSkills[id][1]) {
		add(temp, 255, "\w2. Drop Multi Explosion^n")
		keys |= (1<<1)
	}
	else if (gm_GetPoints(id) >= MULTIEXP_REQP) {
		addpointitem("\w2. Buy Multi Explosion", MULTIEXP_REQP)
		keys |= (1<<1)
	}
	else
		addpointitem("\d2. Buy Multi Explosion", MULTIEXP_REQP)
	/* Auto-Reload */
	if (gSkills[id][2]) {
		add(temp, 255, "\w3. Drop Auto-Reload^n")
		keys |= (1<<2)
	}
	else if (gm_GetPoints(id) >= RELOAD_REQP) {
		addpointitem("\w3. Buy Auto-Reload", RELOAD_REQP)
		keys |= (1<<2)
	}
	else
		addpointitem("\d3. Buy Auto-Reload", RELOAD_REQP)
	/* Extra Ammo */
	if (gSkills[id][3]) {
		add(temp, 255, "\w4. Drop Extra Ammo^n")
		keys |= (1<<3)
	}
	else if (gm_GetPoints(id) >= AMMO_REQP) {
		addpointitem("\w4. Buy Extra Ammo", AMMO_REQP)
		keys |= (1<<3)
	}
	else
		addpointitem("\d4. Buy Extra Ammo", AMMO_REQP)
	/* Strength (hp+armor) */
	if (gSkills[id][4]) {
		add(temp, 255, "\w5. Drop Strength (hp+armor)^n")
		keys |= (1<<4)
	}
	else if (gm_GetPoints(id) >= STRENGTH_REQP) {
		addpointitem("\w5. Buy Strength (hp+armor)", STRENGTH_REQP)
		keys |= (1<<4)
	}
	else
		addpointitem("\d5. Buy Strength (hp+armor)", STRENGTH_REQP)
	/* Chicken rockets */
	if (gSkills[id][5]) {
		add(temp, 255, "\w6. Drop Chicken rockets^n")
		keys |= (1<<5)
	}
	else if (gm_GetPoints(id) >= CHICKEN_REQP) {
		addpointitem("\w6. Buy Chicken rockets", CHICKEN_REQP)
		keys |= (1<<5)
	}
	else
		addpointitem("\d6. Buy Chicken rockets", CHICKEN_REQP)
	add(temp, 255, "^n\w0. Exit")
	
	show_menu(id, keys, temp, -1, "BuyMenu") // Display menu
}

addpointitem(title[], points) {
	new tmp[64]
	format(tmp, 63, "%s (%d points)^n", title, points)
	add(temp, 255, tmp)
}

public PressedBuyMenu(id, key) {
	if (!g_IsEnabled) return
	
	switch (key) {
		case 0: { // Extra Speed
			if (gSkills[id][0]) {
				gm_AddPoints(id, SPEED_REQP)
				gSkills[id][0] = 0
				set_pev(id, pev_maxspeed, 320.0)
				engfunc(EngFunc_SetClientMaxspeed, id, 320.0)
				client_print(id, print_chat, "[GM] You've dropped Extra Speed and got %d points back.", SPEED_REQP)
			}
			else if (gm_GetPoints(id) >= SPEED_REQP) {
				gm_RemPoints(id, SPEED_REQP)
				gSkills[id][0] = 1
				set_pev(id, pev_maxspeed, 350.0)
				engfunc(EngFunc_SetClientMaxspeed, id, 350.0)
				client_print(id, print_chat, "[GM] You've just bought Extra Speed for %d points.", SPEED_REQP)
			}
		}
		case 1: { // Multi Explosion
			if (gSkills[id][1]) {
				gm_AddPoints(id, MULTIEXP_REQP)
				gSkills[id][1] = 0
				client_print(id, print_chat, "[GM] You've dropped Multi Explosion and got %d points back.", MULTIEXP_REQP)
			}
			else if (gm_GetPoints(id) >= MULTIEXP_REQP) {
				gm_RemPoints(id, MULTIEXP_REQP)
				gSkills[id][1] = 1
				client_print(id, print_chat, "[GM] You've just bought Multi Explosion for %d points.", MULTIEXP_REQP)
			}
		}
		case 2: { // Auto-Reload
			if (gSkills[id][2]) {
				gm_AddPoints(id, RELOAD_REQP)
				gSkills[id][2] = 0
				client_print(id, print_chat, "[GM] You've dropped Auto-Reload and got %d points back.", RELOAD_REQP)
			}
			else if (gm_GetPoints(id) >= RELOAD_REQP) {
				gm_RemPoints(id, RELOAD_REQP)
				gSkills[id][2] = 1
				client_print(id, print_chat, "[GM] You've just bought RPG Auto-Reload for %d points.", RELOAD_REQP)
			}
		}
		case 3: { // Extra Ammo
			if (gSkills[id][3]) {
				gm_AddPoints(id, AMMO_REQP)
				gSkills[id][3] = 0
				client_print(id, print_chat, "[GM] You've dropped Extra Ammo and got %d points back.", AMMO_REQP)
			}
			else if (gm_GetPoints(id) >= AMMO_REQP) {
				gm_RemPoints(id, AMMO_REQP)
				gSkills[id][3] = 1
				client_print(id, print_chat, "[GM] You've just bought Extra Ammo for %d points.", AMMO_REQP)
			}
		}
		case 4: { // Strength (hp+armor)
			if (gSkills[id][4]) {
				gm_AddPoints(id, STRENGTH_REQP)
				gSkills[id][4] = 0
				client_print(id, print_chat, "[GM] You've dropped Strength and got %d points back.", STRENGTH_REQP)
			}
			else if (gm_GetPoints(id) >= STRENGTH_REQP) {
				gm_RemPoints(id, STRENGTH_REQP)
				gSkills[id][4] = 1
				client_print(id, print_chat, "[GM] You've just bought Strength (hp+armor) for %d points.", STRENGTH_REQP)
			}
		}
		case 5: { // Chicken rockets
			if (gSkills[id][5]) {
				gm_AddPoints(id, CHICKEN_REQP)
				gSkills[id][5] = 0
				client_print(id, print_chat, "[GM] You've dropped Chicken rockets and got %d points back.", CHICKEN_REQP)
			}
			else if (gm_GetPoints(id) >= CHICKEN_REQP) {
				gm_RemPoints(id, CHICKEN_REQP)
				gSkills[id][5] = 1
				client_print(id, print_chat, "[GM] You've just bought Chicken rockets for %d points.", CHICKEN_REQP)
			}
		}
		case 9: {
			return
		}
	}
	show_buymenu(id)
}
